/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.HashSet;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;

final class PendingReceiverTable
extends DebugObject {
    private LongHashTable<PendingReceiverEntry> m_receiverTable = null;

    PendingReceiverTable() {
        this.debugName("PendingReceiverTable");
        this.m_receiverTable = new LongHashTable();
    }

    PendingReceiverEntry get(long clientId) {
        return this.m_receiverTable.get(clientId);
    }

    PendingReceiverEntry remove(long clientId) {
        return this.m_receiverTable.remove(clientId);
    }

    void addGroupMapping(long clientId, String group) {
        PendingReceiverEntry entry = this.get(clientId);
        if (entry == null) {
            entry = new PendingReceiverEntry(clientId);
        }
        entry.m_groupTable.add(group);
        this.m_receiverTable.put(clientId, entry);
    }

    void removeGroupMapping(long clientId, String group) {
        PendingReceiverEntry entry = this.get(clientId);
        if (entry != null) {
            entry.m_groupTable.remove(group);
            if (entry.m_groupTable.isEmpty()) {
                this.m_receiverTable.remove(clientId);
            }
        }
    }

    final class PendingReceiverEntry {
        long m_clientId;
        HashSet<String> m_groupTable;

        PendingReceiverEntry(long clientId) {
            this.m_clientId = clientId;
            this.m_groupTable = new HashSet();
        }
    }
}

