/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IMgram;
import progress.message.util.StreamUtil;
import progress.message.zclient.Label;

public class QueueMsgSendEvt
extends LogEvent {
    private static Label s_label = new Label();
    private short m_eventType = (short)76;
    private long m_msgTracking;
    private long m_receiverId;
    private IMgram m_msg;
    private IClientContext m_receiver;
    private boolean m_isTempQueue;
    private boolean m_deliverOnFlush = true;

    public QueueMsgSendEvt(IClientContext cc, long tracking, IMgram msg, boolean isTempQueue, boolean deliverOnFlush) {
        this.m_receiver = cc;
        this.m_receiverId = cc.getId();
        this.m_msgTracking = tracking;
        this.m_msg = msg;
        this.m_isTempQueue = isTempQueue;
        this.m_deliverOnFlush = deliverOnFlush;
        this.setReplicateOnly(msg.isNonPersistentReplicated());
        if (this.DEBUG) {
            this.debug("Constructor; tracking= " + tracking);
        }
    }

    public QueueMsgSendEvt(short eventType) {
        this.m_eventType = eventType;
    }

    @Override
    public short type() {
        return 76;
    }

    IClientContext getReceiver() {
        return this.m_receiver;
    }

    long getReceiverId() {
        return this.m_receiverId;
    }

    long getTracking() {
        return this.m_msgTracking;
    }

    @Override
    protected void onFlush() {
        if (this.DEBUG) {
            this.debug("onFlush starting ");
        }
        if (this.m_deliverOnFlush) {
            this.deliverMsg();
        }
    }

    protected void deliverMsg() {
        int result = this.m_receiver.xOnceQSendFromLog(this.m_msg, s_label);
        if (this.DEBUG) {
            this.debug("ClientContext.send() returned " + result);
        }
        switch (result) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                this.m_receiver.restoreUnsentQMsgs(false);
            }
        }
        if (this.DEBUG) {
            this.debug("onFlush conpleted ");
        }
    }

    @Override
    public int memSizeBody() {
        return 16;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 16;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_msgTracking, os);
        StreamUtil.writeLong(this.m_receiverId, os);
        StreamUtil.writeBoolean(this.m_isTempQueue, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        block3: {
            this.m_msgTracking = StreamUtil.readLong(in);
            this.m_receiverId = StreamUtil.readLong(in);
            this.m_isTempQueue = this.m_eventType == 76 ? StreamUtil.readBoolean(in) : false;
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            if (reg != null && this.m_receiverId != 0L) {
                try {
                    this.m_receiver = reg.getClient(this.m_receiverId);
                }
                catch (EClientNotRegistered e) {
                    if (!this.DEBUG) break block3;
                    this.debug("Client not found " + this.m_receiverId);
                }
            }
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoQueueMsgSend(this.m_msgTracking, this.m_receiverId);
    }

    @Override
    public String toString() {
        return super.toString() + "QueueMsgSend " + this.m_msgTracking;
    }
}

