/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.SortedMap;
import org.apache.axis.InternalException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class RMInboundEvt
extends LogEvent {
    private String m_requestMid;
    private EndpointReference m_requestReplyTo;
    private EndpointReference m_acksTo;
    private EndpointReference m_endpoint;
    private String m_requestReplyToS;
    private String m_acksToS;
    private String m_endpointS;
    private String m_sequenceIdentifier;
    private String m_returnSequenceIdentifier;
    private String m_rmConstantsURI;
    private String m_soapConstantsURI;
    private Date m_expires;
    private RMPolicy m_policy;
    private String m_wsaNS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private long m_designatedLastMessageNumber;
    private ArrayList m_messageList;
    private short m_type = (short)128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMInboundEvt(RMReceiveSequence rrs) {
        RMSequence seqState = rrs.getSequenceState();
        if (rrs.getRequestReplyTo() != null) {
            this.m_requestReplyTo = rrs.getRequestReplyTo();
            this.m_requestReplyToS = this.stringify(this.m_requestReplyTo);
        }
        if (rrs.getRequestMessageID() != null) {
            this.m_requestMid = rrs.getRequestMessageID().toString();
        }
        if (seqState.getAcksTo() != null) {
            try {
                this.m_acksTo = seqState.getAcksTo().getAddress();
                this.m_acksToS = this.stringify(this.m_acksTo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_endpoint = seqState.getEndpointReference();
        if (this.m_endpoint != null) {
            this.m_endpointS = this.stringify(this.m_endpoint);
        }
        this.m_sequenceIdentifier = seqState.getSequenceIdentifier().getIdentifier().toString();
        this.m_returnSequenceIdentifier = seqState.getReturnSequenceIdentifier();
        this.m_rmConstantsURI = rrs.getConstants().getNSURI();
        this.m_soapConstantsURI = rrs.getSOAPConstants().getEnvelopeURI();
        this.m_expires = seqState.getExpires();
        this.m_policy = seqState.getPolicy();
        this.m_designatedLastMessageNumber = seqState.getDesignatedLastMessageNumber();
        this.m_wsaNS = rrs.getWSANS();
        SortedMap map = seqState.getMessageList();
        Set set = map.keySet();
        SortedMap sortedMap = map;
        synchronized (sortedMap) {
            this.m_messageList = new ArrayList(map.size());
            for (Long l : set) {
                this.m_messageList.add(l);
            }
        }
        this.setType();
    }

    private void setType() {
        this.m_type = this.type();
    }

    RMInboundEvt(short type) {
        this.m_type = type;
    }

    @Override
    public short type() {
        return 128;
    }

    public EndpointReference getRequestReplyTo() {
        return this.m_requestReplyTo;
    }

    public String getRequestMid() {
        return this.m_requestMid;
    }

    public EndpointReference getAcksTo() {
        return this.m_acksTo;
    }

    public EndpointReference getEndpointReference() {
        return this.m_endpoint;
    }

    public String getSequenceIdentifier() {
        return this.m_sequenceIdentifier;
    }

    public String getReturnSequenceIdentifier() {
        return this.m_returnSequenceIdentifier;
    }

    public String getWSANS() {
        return this.m_wsaNS;
    }

    public String getRMConstantsURI() {
        return this.m_rmConstantsURI;
    }

    public String getSoapConstantsURI() {
        return this.m_soapConstantsURI;
    }

    public Date getExpires() {
        return this.m_expires;
    }

    public RMPolicy getPolicy() {
        return this.m_policy;
    }

    public long getDesignatedLastMessageNumber() {
        return this.m_designatedLastMessageNumber;
    }

    public ArrayList getMessageList() {
        return this.m_messageList;
    }

    @Override
    protected int memSizeBody() {
        int syncExtras = this.retrieveSyncExtras();
        int size = this.memSize(this.m_requestReplyToS) + this.memSize(this.m_requestMid) + this.memSize(this.m_acksToS) + this.memSize(this.m_endpointS) + this.memSize(this.m_sequenceIdentifier) + this.memSize(this.m_returnSequenceIdentifier) + this.memSize(this.m_rmConstantsURI) + this.memSize(this.m_soapConstantsURI) + (this.m_expires != null ? 8 : 0) + (this.m_policy != null ? this.m_policy.memsize() : 0) + this.memSize(this.m_wsaNS) + syncExtras;
        return size;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        this.writeNullOrUTF(this.m_requestReplyToS, os);
        this.writeNullOrUTF(this.m_requestMid, os);
        this.writeNullOrUTF(this.m_acksToS, os);
        this.writeNullOrUTF(this.m_endpointS, os);
        this.writeNullOrUTF(this.m_sequenceIdentifier, os);
        this.writeNullOrUTF(this.m_returnSequenceIdentifier, os);
        this.writeNullOrUTF(this.m_rmConstantsURI, os);
        this.writeNullOrUTF(this.m_soapConstantsURI, os);
        StreamUtil.writeLong(this.m_expires == null ? 0L : this.m_expires.getTime(), os);
        StreamUtil.writeBoolean(this.m_policy != null, os);
        if (this.m_policy != null) {
            this.m_policy.toLogStream(os);
        }
        this.writeNullOrUTF(this.m_wsaNS, os);
        if (this.m_type == 130 || this.m_type == 121) {
            StreamUtil.writeLong(this.m_designatedLastMessageNumber, os);
            StreamUtil.writeLong((long)this.m_messageList.size(), os);
            for (Long l : this.m_messageList) {
                StreamUtil.writeLong((long)l, os);
            }
        }
    }

    private int memSize(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    private void writeNullOrUTF(String s, OutputStream os) throws IOException {
        byte[] b = StringUtil.stringToUTF("");
        if (s == null) {
            os.write(b, 0, b.length);
        } else {
            b = StringUtil.stringToUTF(s);
            os.write(b, 0, b.length);
        }
    }

    private int serializedSizeNullOrUTF(String s) {
        try {
            byte[] b = StringUtil.stringToUTF("");
            if (s != null) {
                b = StringUtil.stringToUTF(s);
            }
            return b.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String readNullOrUTF(InputStream is) throws IOException {
        String s = StreamUtil.readUTF(is);
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_requestReplyToS = this.readNullOrUTF(in);
        if (this.m_requestReplyToS != null) {
            this.m_requestReplyTo = this.parse(this.m_requestReplyToS);
            this.m_requestReplyToS = this.stringifyData(this.m_requestReplyToS, this.m_requestReplyTo);
        }
        this.m_requestMid = this.readNullOrUTF(in);
        this.m_acksToS = this.readNullOrUTF(in);
        if (this.m_acksToS != null) {
            this.m_acksTo = this.parseAcksTo(this.m_acksToS);
            this.m_acksToS = this.stringifyData(this.m_acksToS, this.m_acksTo);
        }
        this.m_endpointS = this.readNullOrUTF(in);
        if (this.m_endpointS != null) {
            this.m_endpoint = this.parse(this.m_endpointS);
            this.m_endpointS = this.stringifyData(this.m_endpointS, this.m_endpoint);
        }
        this.m_sequenceIdentifier = this.readNullOrUTF(in);
        this.m_returnSequenceIdentifier = this.readNullOrUTF(in);
        this.m_rmConstantsURI = this.readNullOrUTF(in);
        this.m_soapConstantsURI = this.readNullOrUTF(in);
        long exp = StreamUtil.readLong(in);
        if (exp != 0L) {
            this.m_expires = new Date(exp);
        }
        if (StreamUtil.readBoolean(in)) {
            this.m_policy = new RMPolicy();
            this.m_policy.fromLogStream(in);
        }
        if (this.m_type == 130 || this.m_type == 128) {
            this.m_wsaNS = this.readNullOrUTF(in);
        }
        if (this.m_type == 121 || this.m_type == 130) {
            long mll;
            this.m_designatedLastMessageNumber = StreamUtil.readLong(in);
            this.m_messageList = new ArrayList((int)mll);
            for (mll = StreamUtil.readLong(in); mll > 0L; --mll) {
                this.m_messageList.add(new Long(StreamUtil.readLong(in)));
            }
        }
    }

    private String stringifyData(String m_acksToSParam, EndpointReference m_acksTo) {
        String m_acksToS = m_acksToSParam;
        if (this.m_type == 121 || this.m_type == 119) {
            m_acksToS = this.stringify(m_acksTo);
        }
        return m_acksToS;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        RMManager.getRMManager().redoBegin(this);
    }

    protected String summary() {
        return this.m_sequenceIdentifier + " dest: " + this.m_endpoint + (this.m_acksTo != null ? " acksTo: " + this.m_acksTo : "") + (this.m_policy != null ? " policy: " + this.m_policy.toString() : "") + (this.m_expires != null ? "m_expires:" + this.m_expires.toString() : "");
    }

    @Override
    public String toString() {
        return "RMInboundEvt: " + this.summary();
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        int syncExtras = this.retrieveSyncExtras();
        int size = this.serializedSizeNullOrUTF(this.m_requestReplyToS) + this.serializedSizeNullOrUTF(this.m_requestMid) + this.serializedSizeNullOrUTF(this.m_acksToS) + this.serializedSizeNullOrUTF(this.m_endpointS) + this.serializedSizeNullOrUTF(this.m_sequenceIdentifier) + this.serializedSizeNullOrUTF(this.m_returnSequenceIdentifier) + this.serializedSizeNullOrUTF(this.m_rmConstantsURI) + this.serializedSizeNullOrUTF(this.m_soapConstantsURI) + 8 + 1 + (this.m_policy != null ? this.m_policy.serSize() : 0) + this.serializedSizeNullOrUTF(this.m_wsaNS) + syncExtras;
        return size;
    }

    private int retrieveSyncExtras() {
        int syncExtras = 0;
        if (this.m_type == 121 || this.m_type == 130) {
            syncExtras = 16 + this.m_messageList.size() * 8;
        }
        return syncExtras;
    }

    private String stringify(EndpointReference epr) {
        Element e = epr.toDOM(null);
        return XMLUtils.ElementToString((Element)e);
    }

    private EndpointReference parse(String s) throws IOException {
        if (s == null) {
            return null;
        }
        try {
            if (this.m_type == 121 || this.m_type == 119) {
                return new EndpointReference(new Address(s));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            Element el = XMLUtils.newDocument((InputStream)bais).getDocumentElement();
            return new EndpointReference(el);
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private EndpointReference parseAcksTo(String s) {
        if (s == null) {
            return null;
        }
        if (this.m_type == 121 || this.m_type == 119) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.m_acksToS.getBytes());
            SOAPBodyElement sbe = new SOAPBodyElement((InputStream)bais);
            AcksTo a2 = new AcksTo((MessageElement)sbe);
            return a2.getAddress();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
        try {
            Element el = XMLUtils.newDocument((InputStream)bais).getDocumentElement();
            return new EndpointReference(el);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }
}

