/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import progress.message.broker.prAccessor;

public class RandomAccessBlockFile {
    private RandomAccessFile file;
    private static final int blockSize = 512;
    private byte[] buf = new byte[512];
    private final String path;
    private final String mode;

    public RandomAccessBlockFile(String path, String mode) throws SecurityException, IOException, IllegalArgumentException {
        this.path = path;
        this.mode = mode;
        this.file = new RandomAccessFile(path, mode);
    }

    public long getBlockNumber() throws IOException {
        long pos = this.file.getFilePointer();
        if (pos % 512L != 0L) {
            throw new RuntimeException(prAccessor.getString("STR234"));
        }
        return pos / 512L;
    }

    public void seek(long blockPos) throws IOException {
        if (blockPos == -1L) {
            this.file.seek(this.file.length());
            if (this.file.getFilePointer() % 512L != 0L) {
                throw new RuntimeException(prAccessor.getString("STR235"));
            }
        } else {
            this.file.seek(blockPos * 512L);
        }
    }

    public long length() throws IOException {
        long len = this.file.length();
        if (len % 512L != 0L) {
            throw new RuntimeException(prAccessor.getString("STR236"));
        }
        return len / 512L;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public void truncate() throws IOException {
        if (this.file.getFilePointer() % 512L != 0L) {
            throw new RuntimeException(prAccessor.getString("STR237"));
        }
        if (this.file.length() == this.file.getFilePointer()) {
            return;
        }
        String truncatedName = this.path + "x";
        FileOutputStream truncateStream = new FileOutputStream(truncatedName);
        this.file.seek(0L);
        byte[] buf = new byte[512];
        for (long numberOfBlocks = this.file.getFilePointer() / 512L; numberOfBlocks >= 0L; --numberOfBlocks) {
            this.file.readFully(buf);
            truncateStream.write(buf);
        }
        truncateStream.close();
        File pathFile = new File(this.path);
        File truncatedFile = new File(truncatedName);
    }

    public static int getBlockSize() {
        return 512;
    }

    public int read(byte[] b) throws IOException, NullPointerException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        int ret = this.file.read(b, off, len);
        long position = this.file.getFilePointer();
        long blockCount = (position + 512L - 1L) / 512L;
        this.file.seek(blockCount * 512L);
        if (this.file.getFilePointer() % 512L != 0L) {
            throw new RuntimeException(prAccessor.getString("STR238"));
        }
        return ret;
    }

    public void write(byte[] b) throws IOException, NullPointerException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        this.file.write(b, off, len);
        int remainder = (int)this.file.getFilePointer() % 512;
        if (remainder > 0) {
            int extra = 512 - remainder;
            this.file.write(this.buf, 0, extra);
        }
        if (this.file.getFilePointer() % 512L != 0L) {
            throw new RuntimeException(prAccessor.getString("STR239"));
        }
        FileDescriptor fd = this.file.getFD();
        fd.sync();
    }
}

