/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

class ReportPublisherUnblocked
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    ReportPublisherUnblocked(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ReportPublisherUnblocked" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session context, Envelope env) {
        try {
            Message msg = env.getMessage();
            long cid = msg.readLong();
            IClientContext client = this.m_reg.getClient(cid);
            if (this.DEBUG) {
                this.debug("Processing unblocked event from " + cid);
            }
            client.getPublishLimiter().generateUnblockedEvent();
        }
        catch (EClientNotRegistered msg) {
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

