/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.LoadBalancer;
import progress.message.broker.loadbalancing.IBrokerContext;
import progress.message.broker.loadbalancing.IConnectionContext;

class RoundRobin
extends LoadBalancer {
    private int scounter = -1;
    private int wcounter = -1;
    private int acounter = 1;

    RoundRobin() {
        super("RoundRobin");
    }

    @Override
    public synchronized boolean onConnect(IConnectionContext cctx) {
        String newBrokerURL = null;
        boolean excludeWeightless = true;
        IBrokerContext[] m_blist = this.m_brokerContext.getNeighborBrokerContexts(excludeWeightless);
        String acceptorName = cctx.getAcceptorName();
        if (this.DEBUG) {
            String printAcceptor = acceptorName;
            if (printAcceptor == null) {
                printAcceptor = "NONE";
            }
            String d = "RoundRobin: onConnect: counters = s:" + this.scounter + " w:" + this.wcounter + " a:" + this.acounter + " from acceptor = " + printAcceptor + " Neighbors:";
            if (m_blist == null || m_blist.length == 0) {
                d = d + " NONE";
            } else {
                String printURLs = this.m_brokerContext.getAcceptorURLs(acceptorName);
                if (printURLs == null) {
                    printURLs = "NONE";
                }
                d = d + "\n Local = " + this.m_brokerContext.getBrokerName() + " weight = " + this.m_brokerContext.getLoadBalancingWeight() + " URLs = " + printURLs + " Cluster = " + this.m_brokerContext.getClusterName();
                for (int i = 0; i < m_blist.length; ++i) {
                    printURLs = m_blist[i].getAcceptorURLs(acceptorName);
                    if (printURLs == null) {
                        printURLs = "NONE";
                    }
                    d = d + "\n Member " + i + " = " + m_blist[i].getBrokerName() + " weight = " + m_blist[i].getLoadBalancingWeight() + " URLs = " + printURLs + " Cluster = " + m_blist[i].getClusterName();
                }
            }
            this.debug(d);
        }
        if (m_blist != null && m_blist.length > 0) {
            boolean endOfListReached = false;
            while (newBrokerURL == null) {
                if (this.scounter > m_blist.length - 1) {
                    if (endOfListReached) break;
                    endOfListReached = true;
                    this.scounter = -1;
                    this.acounter = 1;
                    this.wcounter = -1;
                }
                if (this.scounter < 0) {
                    if (this.wcounter < 0) {
                        this.wcounter = this.m_brokerContext.getLoadBalancingWeight() * RoundRobin.numTokens(this.m_brokerContext.getAcceptorURLs(acceptorName)) - 1;
                        if (this.wcounter < 0) {
                            this.scounter = 0;
                            continue;
                        }
                    }
                    if (this.wcounter-- == 0) {
                        this.scounter = 0;
                    }
                    if (!this.DEBUG) break;
                    this.debug("Counters = s:" + this.scounter + " w:" + this.wcounter + " a:" + this.acounter + ": No redirection");
                    break;
                }
                if (this.wcounter < 0) {
                    this.wcounter = m_blist[this.scounter].getLoadBalancingWeight() - 1;
                }
                String URLList = m_blist[this.scounter].getAcceptorURLs(acceptorName);
                newBrokerURL = RoundRobin.getToken(URLList, this.acounter++);
                if (this.DEBUG && newBrokerURL != null) {
                    String printAcceptor = acceptorName;
                    if (printAcceptor == null) {
                        printAcceptor = "NONE";
                    }
                    this.debug("Counters = s:" + this.scounter + " w:" + this.wcounter + " a:" + this.acounter + ": Re-directing to broker: " + m_blist[this.scounter].getBrokerName() + " URL = " + newBrokerURL);
                }
                if (newBrokerURL != null) continue;
                if (this.wcounter-- == 0) {
                    ++this.scounter;
                }
                this.acounter = 1;
            }
        }
        cctx.setNewBrokerURL(newBrokerURL);
        return true;
    }
}

