/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.HashMap;
import progress.message.broker.LoadBalancer;
import progress.message.broker.loadbalancing.IBrokerContext;
import progress.message.broker.loadbalancing.IConnectionContext;

public class RoundRobinByAcceptor
extends LoadBalancer {
    private final HashMap m_acceptorTable = new HashMap();

    RoundRobinByAcceptor() {
        super("RoundRobinByAcceptor");
    }

    @Override
    public synchronized boolean onConnect(IConnectionContext cctx) {
        AcceptorRRInfo arri = (AcceptorRRInfo)this.m_acceptorTable.get(cctx.getAcceptorName());
        if (arri == null) {
            arri = new AcceptorRRInfo(cctx.getAcceptorName());
            this.m_acceptorTable.put(cctx.getAcceptorName(), arri);
        }
        arri.onConnect(cctx);
        return true;
    }

    private class AcceptorRRInfo {
        int bcounter = -1;
        int wcounter = -1;
        int acounter = 1;
        final String m_acceptorName;

        AcceptorRRInfo(String acceptorName) {
            this.m_acceptorName = acceptorName;
        }

        final boolean onConnect(IConnectionContext cctx) {
            String newBrokerURL = null;
            boolean excludeWeightless = true;
            IBrokerContext[] m_blist = RoundRobinByAcceptor.this.m_brokerContext.getNeighborBrokerContexts(excludeWeightless);
            String acceptorName = cctx.getAcceptorName();
            if (m_blist != null && m_blist.length > 0) {
                boolean endOfListReached = false;
                while (newBrokerURL == null) {
                    if (this.bcounter >= m_blist.length) {
                        if (endOfListReached) break;
                        endOfListReached = true;
                        this.bcounter = -1;
                        this.wcounter = -1;
                        this.acounter = 1;
                    }
                    if (this.bcounter < 0) {
                        if (this.wcounter < 0) {
                            this.wcounter = RoundRobinByAcceptor.this.m_brokerContext.getLoadBalancingWeight() * LoadBalancer.numTokens(RoundRobinByAcceptor.this.m_brokerContext.getAcceptorURLs(acceptorName)) - 1;
                            if (this.wcounter < 0) {
                                this.bcounter = 0;
                                continue;
                            }
                        }
                        if (this.wcounter-- == 0) {
                            this.bcounter = 0;
                        }
                        if (!RoundRobinByAcceptor.this.DEBUG) break;
                        RoundRobinByAcceptor.this.debug("Counters for " + this.m_acceptorName + ": b: " + this.bcounter + " w:" + this.wcounter + " a:" + this.acounter + ": No redirection");
                        break;
                    }
                    if (this.wcounter < 0) {
                        this.wcounter = m_blist[this.bcounter].getLoadBalancingWeight() - 1;
                    }
                    String URLList = m_blist[this.bcounter].getAcceptorURLs(acceptorName);
                    newBrokerURL = LoadBalancer.getToken(URLList, this.acounter++);
                    if (RoundRobinByAcceptor.this.DEBUG && newBrokerURL != null) {
                        String printAcceptor = acceptorName;
                        if (printAcceptor == null) {
                            printAcceptor = "NONE";
                        }
                        RoundRobinByAcceptor.this.debug("Counters for " + this.m_acceptorName + ": s:" + this.bcounter + " w:" + this.wcounter + " a:" + this.acounter + ": Re-directing to broker: " + m_blist[this.bcounter].getBrokerName() + " URL = " + newBrokerURL);
                    }
                    if (newBrokerURL != null) continue;
                    if (this.wcounter-- == 0) {
                        ++this.bcounter;
                    }
                    this.acounter = 1;
                }
            }
            cctx.setNewBrokerURL(newBrokerURL);
            return true;
        }
    }
}

