/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.QElement;
import progress.message.msg.IMgram;

public class SavableQElement
extends QElement {
    protected long m_tte = 0L;
    protected byte m_flags = 0;
    protected boolean m_asyncReq = false;
    protected QElement m_prevInMemory = null;
    protected QElement m_nextInMemory = null;
    private static final byte m_saveMask = 1;
    private static final byte m_inDbMask = 8;
    private static final byte m_postProcessMask = 64;
    private static final byte m_deliveredMask = 0;

    public SavableQElement(Object payload, long tracking, int prio, long sz, long tte) {
        super(payload, tracking, prio, sz);
        this.m_tte = tte;
    }

    public synchronized void repopulate(Object payload, long tracking, int prio, long sz, long tte) {
        this.m_payload = payload;
        this.m_tracking = tracking;
        this.m_prio = (byte)prio;
        this.m_size = sz;
        this.m_tte = tte;
        this.m_asyncReq = false;
    }

    public synchronized void setTTE(long tte) {
        this.m_tte = tte;
    }

    public synchronized long getTTE() {
        return this.m_tte;
    }

    public synchronized void setSaved() {
        this.m_flags = (byte)(this.m_flags | 1);
    }

    public synchronized void unsetSaved() {
        this.m_flags = (byte)(this.m_flags & 0xFFFFFFFE);
    }

    public synchronized boolean isSaved() {
        return this.verifyIsFlagAndProcessMask((byte)1);
    }

    public synchronized void setInDB() {
        this.m_flags = (byte)(this.m_flags | 8);
    }

    public synchronized void unsetInDB() {
        this.m_flags = (byte)(this.m_flags & 0xFFFFFFF7);
    }

    public synchronized boolean isInDB() {
        return this.verifyIsFlagAndProcessMask((byte)8);
    }

    public synchronized void setDelivered() {
        this.m_flags = (byte)(this.m_flags | 0);
    }

    public synchronized void unsetDelivered() {
        this.m_flags = (byte)(this.m_flags & 0xFFFFFFFF);
    }

    public synchronized boolean isDelivered() {
        return this.verifyIsFlagAndProcessMask((byte)0);
    }

    public synchronized void setPostProcess() {
        this.m_flags = (byte)(this.m_flags | 0x40);
    }

    public synchronized void unsetPostProcess() {
        this.m_flags = (byte)(this.m_flags & 0xFFFFFFBF);
    }

    public synchronized boolean isPostProcess() {
        return this.verifyIsFlagAndProcessMask((byte)64);
    }

    private boolean verifyIsFlagAndProcessMask(byte mask) {
        return (this.m_flags & mask) != 0;
    }

    public synchronized void setAsyncReq() {
        this.m_asyncReq = true;
    }

    public synchronized void unsetAsyncReq() {
        this.m_asyncReq = false;
    }

    public synchronized boolean isAsyncReq() {
        return this.m_asyncReq;
    }

    public void setPrevInMemory(QElement prevInMemory) {
        this.m_prevInMemory = prevInMemory;
    }

    public QElement getPrevInMemory() {
        return this.m_prevInMemory;
    }

    public void setNextInMemory(QElement nextInMemory) {
        this.m_nextInMemory = nextInMemory;
    }

    public QElement getNextInMemory() {
        return this.m_nextInMemory;
    }

    public synchronized void postProcess() {
        this.setInDB();
        if (this.isPostProcess()) {
            this.setPayload(null);
        } else {
            Object payload = this.getPayload();
            if (payload != null && payload instanceof IMgram) {
                ((IMgram)payload).getBrokerHandle().setFromDB(true);
            }
        }
    }

    @Override
    public synchronized void recycle() {
        super.recycle();
        this.m_tte = 0L;
        this.m_flags = 0;
        this.m_asyncReq = false;
        this.m_prevInMemory = null;
        this.m_nextInMemory = null;
        this.m_enqueueTime = 0L;
    }

    @Override
    public synchronized Object clone() {
        SavableQElement clone = new SavableQElement(this.m_payload, this.m_tracking, this.m_prio, this.m_size, this.m_tte);
        clone.setReenqueueCount(this.m_reenqueues);
        clone.m_prev = this.m_prev;
        clone.m_next = this.m_next;
        clone.m_flags = this.m_flags;
        clone.m_asyncReq = this.m_asyncReq;
        clone.m_prevInMemory = this.m_prevInMemory;
        clone.m_nextInMemory = this.m_nextInMemory;
        clone.m_enqueueTime = this.m_enqueueTime;
        return clone;
    }

    @Override
    public String toString() {
        return "SavableQElement - tracking ID:" + this.m_tracking + ", priority:" + this.m_prio + ", size:" + this.m_size + ", reenqueues:" + this.m_reenqueues + ", tte:" + this.m_tte + ", payload:" + this.m_payload + ", isSaved:" + this.isSaved() + ", isInDB:" + this.isInDB() + ", isDelivered:" + this.isDelivered() + ", isPostProcess:" + this.isPostProcess() + ", isAsyncReq:" + this.isAsyncReq() + ", enqueueTime: " + this.m_enqueueTime;
    }
}

