/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.ProgressJMSClassHandler;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;

public class Service {
    public static final String COMMAND = "$ISYS.service.command";
    public static final String ANNOUNCE = "$ISYS.service.announce";
    public static final byte STATE_INITIALIZED = 0;
    public static final byte STATE_STARTED = 1;
    public static final byte STATE_STOPPED = 2;
    public static final byte STATE_SHUTDOWN = 3;
    public static final byte STATE_EXIT = 4;
    private Session session;
    private Connection connect;
    private byte state = (byte)3;
    private String configClassName = "";
    private String instance;
    private String className;
    private String hostname = "<unknown>";

    public Service(String instance) {
        this(instance, null);
    }

    public Service(String instance, String classNameParam) {
        String className = classNameParam;
        if (className == null) {
            className = this.getClass().getName();
        }
        if (instance == null) {
            instance = "";
        }
        this.instance = instance.replace('.', '/');
        this.className = className.replace('.', '/');
        try {
            this.hostname = InetAddress.getLocalHost().getHostName().replace('.', '/') + ':' + Config.PORT;
        }
        catch (UnknownHostException e) {
            this.hostname = "localhost";
        }
    }

    public void setEditor(String configClassName) {
        if (configClassName != null) {
            this.configClassName = configClassName;
        }
    }

    public void register(Connection connection) throws EGeneralException {
        this.connect = connection;
        this.session = new Session(connection);
        String jSubject = this.getCommandSubject2("java");
        ProgressJMSClassHandler jHandler = new ProgressJMSClassHandler(jSubject);
        this.connect.addMessageHandler(jHandler);
        this.session.subscribe(jSubject);
        this.registerHandler(new InitHandler(), this.getCommandSubject2("init"));
        this.registerHandler(new StartHandler(), this.getCommandSubject2("start"));
        this.registerHandler(new StopHandler(), this.getCommandSubject2("stop"));
        this.registerHandler(new ShutdownHandler(), this.getCommandSubject2("shutdown"));
        this.registerHandler(new RestartHandler(), this.getCommandSubject2("restart"));
        this.registerHandler(new ExitHandler(), this.getCommandSubject2("exit"));
        this.registerHandler(new InfoHandler(), this.getCommandSubject2("info"));
        this.registerHandler(new AnnounceHandler(), ANNOUNCE);
        this.base_init();
        this.base_start();
    }

    protected Session getSession() {
        return this.session;
    }

    protected void serviceInit() {
    }

    protected void serviceStart() {
    }

    protected void serviceStop() {
    }

    protected void serviceDestroy() {
    }

    protected void setConfigPath(String ConfigFilePath) {
    }

    protected void serviceRestart() {
        this.base_stop();
        this.base_shutdown();
        this.base_init();
        this.base_start();
    }

    protected void serviceAbort() {
        throw new Error("Unsupported usage");
    }

    void base_init() {
        if (this.state != 3) {
            return;
        }
        this.serviceInit();
        this.set_state((byte)0);
    }

    void base_start() {
        if (this.state == 1) {
            return;
        }
        if (this.state == 3) {
            this.base_init();
        }
        this.serviceStart();
        this.set_state((byte)1);
    }

    void base_stop() {
        if (this.state != 1) {
            return;
        }
        this.serviceStop();
        this.set_state((byte)2);
    }

    void base_shutdown() {
        if (this.state == 0) {
            this.base_start();
        }
        if (this.state == 1) {
            this.base_stop();
        }
        if (this.state != 2) {
            return;
        }
        this.serviceDestroy();
        this.set_state((byte)3);
    }

    protected void set_state(byte new_state) {
        this.state = new_state;
        this.announce_state();
    }

    void announce_state() {
        block5: {
            try {
                Message msg = new Message(ANNOUNCE);
                msg.writeUTF(this.className);
                msg.writeUTF(this.instance);
                msg.writeUTF(this.hostname);
                msg.writeByte(this.state);
                if (this.session == null) break block5;
                try {
                    this.session.publish(msg);
                }
                catch (ENetworkFailure enf) {
                    if (!Broker.isInShutdown()) {
                        throw enf;
                    }
                }
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    public static String getCommandSubject(String className, String instance, String hostname, String operation) {
        return "$ISYS.service.command." + className + "." + instance + "." + hostname + "." + operation;
    }

    public String getCommandSubject2(String operation) {
        return Service.getCommandSubject(this.className, this.instance, this.hostname, operation);
    }

    private void registerHandler(MessageHandler handler, String subjectName) {
        try {
            handler.replaceHandler(handler);
            handler.bind(subjectName);
            this.connect.addMessageHandler(handler);
            this.session.subscribe(subjectName);
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    private class AnnounceHandler
    extends MessageHandler
    implements IMessageHandler {
        AnnounceHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            try {
                if (envelope.isRequest()) {
                    Message reply = new Message();
                    reply.writeUTF(Service.this.className);
                    reply.writeUTF(Service.this.instance);
                    reply.writeUTF(Service.this.hostname);
                    reply.writeByte(Service.this.state);
                    session.reply(reply, envelope);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class InfoHandler
    extends MessageHandler
    implements IMessageHandler {
        InfoHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            try {
                Message reply = new Message();
                reply.writeUTF(Service.this.configClassName);
                session.reply(reply, envelope);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ExitHandler
    extends MessageHandler
    implements IMessageHandler {
        ExitHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            Service.this.serviceAbort();
        }
    }

    private class RestartHandler
    extends MessageHandler
    implements IMessageHandler {
        RestartHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            Service.this.serviceRestart();
        }
    }

    private class ShutdownHandler
    extends MessageHandler
    implements IMessageHandler {
        ShutdownHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            Service.this.base_shutdown();
        }
    }

    private class StopHandler
    extends MessageHandler
    implements IMessageHandler {
        StopHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            Service.this.base_stop();
        }
    }

    private class StartHandler
    extends MessageHandler
    implements IMessageHandler {
        StartHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            Service.this.base_start();
        }
    }

    private class InitHandler
    extends MessageHandler
    implements IMessageHandler {
        InitHandler() {
            super(null);
        }

        @Override
        public void handleMessage(Session session, Envelope envelope) {
            Service.this.base_init();
        }
    }
}

