/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import progress.message.broker.ISubscriptionData;

public class SubscriptionData
implements ISubscriptionData,
Serializable {
    static final long serialVersionUID = -1946989810585556025L;
    private static final short CURRENT_VERSION = 0;
    private String m_clientID;
    private String m_topicName;
    private String[] m_selectors;
    private boolean m_selAtBroker;
    private long m_messageCount;
    private long m_messageSize;
    static final short TOPIC_FLAG = 1;
    static final short SELECTOR_FLAG = 2;

    public SubscriptionData() {
    }

    public SubscriptionData(String clientID, String topicName, String[] selectors, boolean selAtBroker, long messageCount, long messageSize) {
        this.m_clientID = clientID;
        this.m_topicName = topicName;
        this.m_selectors = selectors;
        this.m_selAtBroker = selAtBroker;
        this.m_messageCount = messageCount;
        this.m_messageSize = messageSize;
    }

    @Override
    public String getClientID() {
        return this.m_clientID;
    }

    @Override
    public String getTopicName() {
        return this.m_topicName;
    }

    @Override
    public String[] getSelectors() {
        return this.m_selectors;
    }

    @Override
    public boolean getSelAtBroker() {
        return this.m_selAtBroker;
    }

    @Override
    public long getMessageCount() {
        return this.m_messageCount;
    }

    @Override
    public long getMessageSize() {
        return this.m_messageSize;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        short flags = 0;
        if (this.m_topicName != null) {
            flags = (short)(flags | 1);
        }
        if (this.m_selectors != null) {
            flags = (short)(flags | 2);
        }
        stream.writeShort(flags);
        stream.writeUTF(this.m_clientID);
        if (this.m_topicName != null) {
            stream.writeUTF(this.m_topicName);
        }
        stream.writeLong(this.m_messageCount);
        stream.writeLong(this.m_messageSize);
        if (this.m_selectors != null) {
            stream.writeBoolean(this.m_selAtBroker);
            stream.writeInt(this.m_selectors.length);
            for (int ii = 0; ii < this.m_selectors.length; ++ii) {
                stream.writeUTF(this.m_selectors[ii]);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        switch (stream.readShort()) {
            case 0: {
                short flags = stream.readShort();
                this.m_clientID = stream.readUTF();
                this.m_topicName = (flags & 1) != 0 ? stream.readUTF() : null;
                this.m_messageCount = stream.readLong();
                this.m_messageSize = stream.readLong();
                if ((flags & 2) != 0) {
                    this.m_selAtBroker = stream.readBoolean();
                    int numSelectors = stream.readInt();
                    if (numSelectors > 0) {
                        this.m_selectors = new String[numSelectors];
                        for (int ii = 0; ii < this.m_selectors.length; ++ii) {
                            this.m_selectors[ii] = stream.readUTF();
                        }
                        break;
                    }
                    this.m_selectors = null;
                    break;
                }
                this.m_selAtBroker = false;
                this.m_selectors = null;
                break;
            }
        }
    }
}

