/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.SubjectDeleteTracker;
import progress.message.util.LongHashTable;
import progress.message.util.StreamUtil;
import progress.message.zclient.FastVector;

public class SyncDeleteMsgEvt
extends LogEvent {
    private LongHashTable m_pubSub;
    private LongHashTable m_queues;
    private FastVector m_subjectAcks = null;
    private int m_memSize = -1;
    private int m_serializedSize = -1;
    private int m_subjectAckLength = -1;
    private short m_eventType;

    SyncDeleteMsgEvt(LongHashTable pubSub, LongHashTable queues, FastVector subjectAcks, int subjectAckLength) {
        this.m_pubSub = pubSub;
        this.m_queues = queues;
        this.m_subjectAcks = subjectAcks;
        this.m_subjectAckLength = subjectAckLength;
    }

    SyncDeleteMsgEvt(short type) {
        this.m_eventType = type;
    }

    @Override
    public short type() {
        return 118;
    }

    @Override
    protected int memSizeBody() {
        if (this.m_memSize == -1) {
            int result = 8;
            Enumeration ids = this.m_pubSub.elements();
            while (ids.hasMoreElements()) {
                result += 8;
                LongHashTable lht = (LongHashTable)ids.nextElement();
                result += lht.size() * 8;
            }
            result += this.m_queues.size() * 8;
            this.m_memSize = result += this.getSubjecAckLength();
        }
        return this.m_memSize;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        if (this.m_serializedSize == -1) {
            int result = 4;
            Enumeration ids = this.m_pubSub.elements();
            while (ids.hasMoreElements()) {
                result += 8;
                LongHashTable lht = (LongHashTable)ids.nextElement();
                result += 4;
                result += lht.size() * 8;
            }
            result += 4;
            result += this.m_queues.size() * 8;
            result += 4;
            this.m_serializedSize = result += this.getSubjecAckLength();
        }
        return this.m_serializedSize;
    }

    private final int getSubjecAckLength() {
        if (this.m_subjectAckLength == -1) {
            int length = 0;
            if (this.m_subjectAcks != null) {
                for (int i = 0; i < this.m_subjectAcks.m_count; ++i) {
                    length += ((SubjectDeleteTracker)this.m_subjectAcks.m_data[i]).serializedLength();
                }
            }
            this.m_subjectAckLength = length;
        }
        return this.m_subjectAckLength;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        int pubSubsize = this.m_pubSub.size();
        StreamUtil.writeInt(pubSubsize, os);
        if (pubSubsize > 0) {
            Enumeration<Long> midEnum = this.m_pubSub.keys();
            while (midEnum.hasMoreElements()) {
                Long messageId = midEnum.nextElement();
                StreamUtil.writeLong((long)messageId, os);
                LongHashTable table = (LongHashTable)this.m_pubSub.get(messageId);
                int cidSize = table.size();
                StreamUtil.writeInt(cidSize, os);
                if (cidSize <= 0) continue;
                Enumeration<Long> cidEnum = table.keys();
                while (cidEnum.hasMoreElements()) {
                    Long cid = cidEnum.nextElement();
                    StreamUtil.writeLong((long)cid, os);
                }
            }
        }
        int queueSize = this.m_queues.size();
        StreamUtil.writeInt(queueSize, os);
        if (queueSize > 0) {
            Enumeration queueEnum = this.m_queues.elements();
            while (queueEnum.hasMoreElements()) {
                StreamUtil.writeLong((long)((Long)queueEnum.nextElement()), os);
            }
        }
        if (this.m_subjectAcks != null) {
            StreamUtil.writeInt(this.m_subjectAcks.m_count, os);
            for (int i = 0; i < this.m_subjectAcks.m_count; ++i) {
                ((SubjectDeleteTracker)this.m_subjectAcks.m_data[i]).writeToStream(os);
            }
        } else {
            StreamUtil.writeInt(0, os);
        }
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        int pubSubSize = StreamUtil.readInt(in);
        this.m_pubSub = new LongHashTable(pubSubSize);
        for (int count = 0; count < pubSubSize; ++count) {
            long messageId = StreamUtil.readLong(in);
            int cidSize = StreamUtil.readInt(in);
            LongHashTable cids = new LongHashTable(cidSize);
            this.addData(cidSize, in, cids);
            this.m_pubSub.put(messageId, cids);
        }
        int queueSize = StreamUtil.readInt(in);
        this.m_queues = new LongHashTable(queueSize);
        this.addData(queueSize, in, this.m_queues);
        if (this.m_eventType >= 118) {
            int count = StreamUtil.readInt(in);
            this.m_subjectAcks = new FastVector(count);
            for (int i = 0; i < count; ++i) {
                SubjectDeleteTracker tracker = new SubjectDeleteTracker();
                tracker.readFromStream(in);
                this.m_subjectAcks.addElement(tracker);
            }
        }
    }

    private void addData(int cidSize, InputStream in, LongHashTable cids) throws IOException {
        for (int cidCount = 0; cidCount < cidSize; ++cidCount) {
            long cid = StreamUtil.readLong(in);
            cids.put(cid, new Long(cid));
        }
    }

    public Enumeration getPubSubMsgIds() {
        return this.m_pubSub.keys();
    }

    public Enumeration getPubSubCIDs(long messageId) {
        LongHashTable lht = (LongHashTable)this.m_pubSub.get(messageId);
        if (lht != null) {
            return lht.keys();
        }
        return null;
    }

    final FastVector getSubjectAcks() {
        return this.m_subjectAcks;
    }

    public Enumeration getQueueMsgIds() {
        return this.m_queues.elements();
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncDeleteMsgEvt(this);
    }

    @Override
    public String toString() {
        return super.toString() + "SyncDeleteMsgEvt";
    }
}

