/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.EInvalidLogEvent;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

class SyncGuarMsgEvt
extends LogEvent {
    private GuarMsgEvt m_evt;
    private boolean m_delivered;
    private boolean m_needIBGuarAck;
    private boolean m_canceled = false;
    private short m_eventType = (short)106;

    SyncGuarMsgEvt(short version) {
        this.m_eventType = version;
    }

    SyncGuarMsgEvt(GuarMsgEvt evt, boolean delivered, boolean needIBGuarAck, boolean canceled) {
        this.m_evt = evt;
        this.m_delivered = delivered;
        this.m_needIBGuarAck = needIBGuarAck;
        this.m_canceled = canceled;
        this.setReplicateOnly(evt.isReplicateOnly());
    }

    @Override
    public short type() {
        return this.m_eventType;
    }

    @Override
    protected int memSizeBody() {
        return 9 + this.m_evt.memsize();
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    @Override
    protected int streamSizeBody() {
        return this.baseSize() + this.m_evt.streamLength();
    }

    @Override
    protected int serializedSizeBody() {
        return this.baseSize() + this.m_evt.serializedLength();
    }

    private int baseSize() {
        return 3;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytesParam) throws IOException, ELogEventTooLong {
        long maxbytes = maxbytesParam;
        if (maxbytes < (long)this.baseSize()) {
            throw new ELogEventTooLong(this);
        }
        this.writePreEvent(out);
        this.m_evt.write2log(out, maxbytes -= (long)this.baseSize());
    }

    private void writePreEvent(OutputStream os) throws IOException {
        StreamUtil.writeBoolean(this.m_delivered, os);
        StreamUtil.writeBoolean(this.m_needIBGuarAck, os);
        StreamUtil.writeBoolean(this.m_canceled, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writePreEvent(os);
        this.m_evt.writeToStream(os, tteTTLConvert);
    }

    private void readPreEvent(InputStream in) throws IOException {
        this.m_delivered = StreamUtil.readBoolean(in);
        this.m_needIBGuarAck = StreamUtil.readBoolean(in);
        if (this.m_eventType == 106) {
            this.m_canceled = StreamUtil.readBoolean(in);
        }
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EInvalidLogEvent, EMgramFormatError {
        this.readPreEvent(in);
        LogEvent evt = (LogEvent)LogEvent.readFromStream(in, tteTTLConvert);
        try {
            this.m_evt = (GuarMsgEvt)evt;
        }
        catch (ClassCastException e) {
            throw new EUnknownLogEventType(evt.type() + "");
        }
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EInvalidLogEvent, EMgramFormatError {
        this.readPreEvent(in);
        LogEvent evt = LogEvent.readFromLog(in);
        try {
            this.m_evt = (GuarMsgEvt)evt;
        }
        catch (ClassCastException e) {
            throw new EUnknownLogEventType(evt.type() + "");
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncGuarMsg(this.m_evt, this.m_delivered, this.m_needIBGuarAck, this.m_canceled);
    }

    @Override
    public String toString() {
        return super.toString() + "Syncpoint: message " + this.m_evt.toString();
    }
}

