/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.util.StreamUtil;

public class TempQueueData {
    private int m_type;
    private String m_queueName;
    private boolean m_isGlobal;
    private int m_maxSize;

    public TempQueueData() {
    }

    public TempQueueData(String name, int type, boolean isGlobal, int maxSize) {
        this.m_queueName = name;
        this.m_type = type;
        this.m_isGlobal = isGlobal;
        this.m_maxSize = maxSize;
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    public int getQueueType() {
        return this.m_type;
    }

    public boolean isGlobal() {
        return this.m_isGlobal;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public int size() {
        return this.m_queueName.length() + 4 + 1 + 4;
    }

    public void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeUTF(this.m_queueName, os);
        StreamUtil.writeInt(this.m_type, os);
        StreamUtil.writeBoolean(this.m_isGlobal, os);
        StreamUtil.writeInt(this.m_maxSize, os);
    }

    public void readFromStream(InputStream is) throws IOException {
        this.m_queueName = StreamUtil.readUTF(is);
        this.m_type = StreamUtil.readInt(is);
        this.m_isGlobal = StreamUtil.readBoolean(is);
        this.m_maxSize = StreamUtil.readInt(is);
    }
}

