/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.LinkedList;
import java.util.TreeMap;

public class TimerHeap {
    private final TreeMap timers = new TreeMap();
    private int size = 0;

    public final void addAbsolute(Runnable timed, long timeMillis) {
        this.addInternal(timed, timeMillis);
    }

    public final void addRelative(Runnable timed, long delay) {
        this.addInternal(timed, System.currentTimeMillis() + delay);
    }

    private synchronized void addInternal(Runnable timed, long eTime) {
        LinkedList<Runnable> list = new LinkedList<Runnable>();
        list.add(timed);
        LinkedList old = this.timers.put(new Long(eTime), list);
        if (old != null) {
            list.addAll(old);
        }
        ++this.size;
        if (this.size == 1 || old == null && (Long)this.timers.firstKey() == eTime) {
            this.notifyAll();
        }
    }

    public synchronized int size() {
        return this.size;
    }

    public final synchronized long timeToNext() {
        if (this.timers.isEmpty()) {
            return -1L;
        }
        return Math.max(0L, (Long)this.timers.firstKey() - System.currentTimeMillis());
    }

    public synchronized void waitForNextTimer() throws InterruptedException {
        while (true) {
            if (this.timers.isEmpty()) {
                this.wait();
                continue;
            }
            long next = (Long)this.timers.firstKey();
            long now = System.currentTimeMillis();
            if (now >= next) {
                return;
            }
            this.wait(next - now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeReadyTimers() {
        LinkedList ready = null;
        TimerHeap timerHeap = this;
        synchronized (timerHeap) {
            if (this.timers.isEmpty()) {
                return;
            }
            long now = System.currentTimeMillis();
            Long first = (Long)this.timers.firstKey();
            if (first > now) {
                return;
            }
            ready = new LinkedList();
            while (first <= now) {
                ready.addAll((LinkedList)this.timers.remove(first));
                if (this.timers.isEmpty()) break;
                first = (Long)this.timers.firstKey();
            }
            this.size -= ready.size();
        }
        for (Runnable runnable : ready) {
            try {
                runnable.run();
            }
            catch (Throwable thrown) {
                thrown.printStackTrace();
            }
        }
    }
}

