/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ChannelTxnSyncEvt;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ETxnAborted;
import progress.message.broker.ETxnCommitPublishFailed;
import progress.message.broker.ETxnSequenceError;
import progress.message.broker.GlobalTxnAbortEvt;
import progress.message.broker.GlobalTxnCommitEvt;
import progress.message.broker.GlobalTxnEndEvt;
import progress.message.broker.GlobalTxnJoinEvt;
import progress.message.broker.GlobalTxnPrecommitEvt;
import progress.message.broker.GlobalTxnPrepareEvt;
import progress.message.broker.GlobalTxnResumeEvt;
import progress.message.broker.GlobalTxnSuspendEvt;
import progress.message.broker.GlobalTxnSyncEvt;
import progress.message.broker.IClientContext;
import progress.message.broker.IMonitoredObject;
import progress.message.broker.LogEvent;
import progress.message.broker.LogManager;
import progress.message.broker.RequestContext;
import progress.message.broker.SyncTxnEvt;
import progress.message.broker.TransactionMgr;
import progress.message.broker.TxMsg;
import progress.message.broker.TxnAbortBeginEvt;
import progress.message.broker.TxnAbortEvt;
import progress.message.broker.TxnAckPool;
import progress.message.broker.TxnCommitEvt;
import progress.message.broker.TxnContentMgr;
import progress.message.broker.TxnContentMgrFile;
import progress.message.broker.TxnContentMgrLog;
import progress.message.broker.TxnPrecommitEvt;
import progress.message.broker.TxnPrepareEvt;
import progress.message.broker.interceptor.InterceptorManager;
import progress.message.broker.prAccessor;
import progress.message.client.EIntegrityCompromised;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.xonce.IXOnceHandle;

class Transaction
extends DebugObject
implements IMonitoredObject {
    private static boolean ENABLE_PERSISTENCE_IN_LOG = true;
    private static final short NEW = 0;
    private static final short PREPARED = 1;
    private static final short PRECOMMITTED = 3;
    private static final short COMMITTED = 4;
    private static final short ABORTED = 5;
    private static final short NO_DUP_COMMIT_BEG = 6;
    private static final short ENDED = 7;
    private static final short SUSPENDED = 8;
    static final byte PERSIST_TYPE_NONE = 0;
    static final byte PERSIST_TYPE_LOG = 1;
    static final byte PERSIST_TYPE_FILE = 2;
    private static volatile AgentRegistrar s_reg;
    private static volatile LogManager s_logMgr;
    private static volatile TransactionMgr s_txnmgr;
    private static volatile AgentAdminSession s_adminSession;
    private int m_tid;
    private short m_state;
    private long m_owner;
    private String m_ownerUid;
    private String m_ownerAppid;
    private String m_userXid;
    private Object m_xid;
    private boolean m_XAtxn = false;
    private Vector m_participants;
    private boolean m_doNotReplicateLive = false;
    TxnContentMgr m_contentMgr;
    byte m_msgPersistenceType = 0;
    private TxnAckPool m_ackPool = null;
    private int m_lastMsgSeqPublish;
    private boolean m_pendingIncomingMsg;
    private long m_prepTime;
    private long m_lastActiveTime;
    private int m_idleTimeOut;
    private IClientContext m_ownerCtx;
    private static IMessageProtection s_mp;
    private boolean m_inDoubtReqPending;
    private int m_inDoubtReqTracking;
    private boolean m_qCleared;
    private String m_noDupCommitId = "";
    private long m_noDupTimestamp;
    private int m_channelStatus;
    private boolean m_isChannel = false;
    private String m_channelId;
    private static int type_file;
    private static int type_log;
    private static int type_none;
    private static int tx_tot;
    private long m_requestId = 0L;
    private long m_lifespan = 0L;
    private boolean m_chained = false;
    private int m_nextTid = -1;
    private int m_previousTid = -1;
    private short m_replyStatus = 0;
    private boolean DEBUG1;
    private boolean m_recoveredPreparedTxn = false;
    private ArrayList m_pendingStorageAcks = null;
    private long m_lastSentStorageAck = -1L;
    private long m_pendingReceiptAck = -1L;
    private Object m_windowedAckLock = new Object();
    private List<Long> m_receiptAcksPendingStorageAck = Collections.synchronizedList(new ArrayList());

    static void initClass(TransactionMgr txnmgr, AgentRegistrar reg) {
        s_txnmgr = txnmgr;
        s_logMgr = reg.getLogManager();
        s_adminSession = reg.getAdminSession();
        s_reg = reg;
    }

    Transaction(int tid, long owner, String uid, String appid, boolean fromLog) {
        super(DebugState.GLOBAL_DEBUG_ON ? "Transaction " + tid : null);
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG) {
            this.debug("begin");
        }
        this.m_tid = tid;
        this.m_owner = owner;
        this.m_ownerUid = uid;
        this.m_ownerAppid = appid;
        this.m_state = 0;
        this.m_userXid = "";
        this.m_qCleared = fromLog;
        this.m_lastActiveTime = System.currentTimeMillis();
        this.m_idleTimeOut = Config.TXN_IDLE_TIMEOUT * 60 * 1000;
        this.m_msgPersistenceType = 0;
    }

    Transaction(int tid, long owner, String uid, String appid, Object xid, boolean fromLog) {
        this(tid, owner, uid, appid, fromLog);
        this.m_xid = xid;
        this.m_XAtxn = true;
    }

    Transaction(SyncTxnEvt evt, boolean cloneAcks) {
        this(evt.getTid(), evt.getOwner(), evt.getUid(), evt.getAppid(), true);
        this.m_state = evt.getState();
        this.m_userXid = evt.getUserXid();
        this.m_noDupCommitId = evt.getNoDupCommitId();
        this.m_noDupTimestamp = evt.getNoDupTimestamp();
        this.m_isChannel = false;
        this.m_channelId = "";
        this.m_channelStatus = 14;
        this.m_ackPool = cloneAcks && evt.getTxnAckPool() != null ? evt.getTxnAckPool().makeCopy(this.m_tid) : evt.getTxnAckPool();
        this.m_msgPersistenceType = evt.getPersistenceType();
        this.m_requestId = evt.getRequestId();
        this.m_lifespan = evt.getLifespan();
        this.m_chained = evt.getChained();
        this.m_replyStatus = evt.getReplyStatus();
        this.m_previousTid = evt.getPreviousTid();
        if (evt instanceof GlobalTxnSyncEvt) {
            this.m_xid = ((GlobalTxnSyncEvt)evt).getXid();
            this.m_XAtxn = true;
        }
        if (evt instanceof ChannelTxnSyncEvt) {
            ChannelTxnSyncEvt cevt = (ChannelTxnSyncEvt)evt;
            this.m_isChannel = true;
            this.m_channelId = cevt.getChannelId();
            this.m_channelStatus = cevt.getChannelStatus();
        }
    }

    int getTid() {
        return this.m_tid;
    }

    long getOwner() {
        return this.m_owner;
    }

    String getOwnerUid() {
        return this.m_ownerUid;
    }

    String getOwnerAppid() {
        return this.m_ownerAppid;
    }

    TransactionMgr getTransactionMgr() {
        return s_txnmgr;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    boolean getChained() {
        return this.m_chained;
    }

    long getLifespan() {
        return this.m_lifespan;
    }

    short getReplyStatus() {
        return this.m_replyStatus;
    }

    int getPreviousTid() {
        return this.m_previousTid;
    }

    int getNextTid() {
        return this.m_nextTid;
    }

    public boolean isFileBased() {
        return this.m_msgPersistenceType == 2;
    }

    IClientContext getOwnerCC() {
        if (this.m_ownerCtx == null) {
            try {
                this.m_ownerCtx = s_reg.getClient(this.getOwner());
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
        }
        return this.m_ownerCtx;
    }

    synchronized boolean isNew() {
        return this.m_state == 0;
    }

    synchronized boolean isPrepared() {
        return this.m_state == 1;
    }

    synchronized boolean isPrecommitted() {
        return this.m_state == 3;
    }

    synchronized boolean isCommitted() {
        return this.m_state == 4;
    }

    synchronized boolean isAborted() {
        return this.m_state == 5;
    }

    synchronized boolean isXAtransaction() {
        return this.m_XAtxn;
    }

    synchronized boolean isEnded() {
        return this.m_state == 7;
    }

    synchronized boolean isSuspended() {
        return this.m_state == 8;
    }

    synchronized boolean isChannel() {
        return this.m_isChannel;
    }

    synchronized boolean isCompleted() {
        return this.m_state == 4 || this.m_state == 5;
    }

    static boolean isInCompletedState(short state) {
        return state == 4 || state == 5;
    }

    void setRequestId(long requestId) {
        this.m_requestId = requestId;
    }

    void setReplyStatus(short replyStatus) {
        this.m_replyStatus = replyStatus;
    }

    void setPreviousTid(int previousTid) {
        this.m_previousTid = previousTid;
    }

    void setNextTid(int nextTid) {
        this.m_nextTid = nextTid;
    }

    boolean isOrphan() {
        IClientContext cc = null;
        try {
            cc = s_reg.getClient(this.getOwner());
        }
        catch (EClientNotRegistered e) {
            return true;
        }
        if (cc == null) {
            return true;
        }
        return cc.isDisconnected() || cc.isUnregistered();
    }

    short getStatus() {
        return this.m_state;
    }

    Object getXid() {
        return this.m_xid;
    }

    String getUserXid() {
        return this.m_userXid;
    }

    long getPrepTime() {
        return this.m_prepTime;
    }

    synchronized int getLastMsgSeqNo() {
        return this.m_lastMsgSeqPublish;
    }

    synchronized void setLastMsgSeqNo(int seq) {
        if (this.m_state == 3 && seq > this.m_lastMsgSeqPublish) {
            this.m_lastMsgSeqPublish = seq;
        }
    }

    synchronized void updateLastActiveTime() {
        this.m_lastActiveTime = System.currentTimeMillis();
    }

    synchronized boolean isInNoDupCommitBeg() {
        return this.m_state == 6;
    }

    String getNoDupCommitId() {
        return this.m_noDupCommitId;
    }

    synchronized void addAckMsg(IMgram m) throws ETxnSequenceError, ETxnAborted {
        this.updateLastActiveTime();
        if (this.DEBUG) {
            long cid = m.getAckHandle().getClientID();
            long trk = m.getAckHandle().getTrackingNumber();
            if (cid == -1L) {
                this.debug("************ ack cid == ClientSecurityContext.NO_PARENT");
            }
            this.debug("addAckMsg cid= " + cid + " trk= " + trk);
        }
        if (this.m_state != 0) {
            throw new ETxnSequenceError("addAckMsg");
        }
        if (this.m_ackPool == null) {
            this.m_ackPool = new TxnAckPool(this.m_tid);
        }
        this.m_ackPool.add(m);
    }

    private boolean isRecoveredPreparedTxn() {
        return this.m_recoveredPreparedTxn;
    }

    Hashtable getMsgTrackings() {
        if (this.m_ackPool == null) {
            return null;
        }
        this.m_recoveredPreparedTxn = true;
        return this.m_ackPool.getMsgTrackings();
    }

    private void sendMsgsBackToQ() {
        if (this.m_ackPool == null) {
            return;
        }
        this.m_ackPool.sendMsgsBackToQ(s_txnmgr, this.m_tid);
    }

    int getBufferSize() {
        int clientTxnBufferSize = Config.TXN_BUFFER_SIZE;
        IClientContext owner = this.getOwnerCC();
        if (owner != null && owner.isXOnce() && ((clientTxnBufferSize = (int)owner.getClientConnectParms().getClientTransactionBufferSize()) == 0 || clientTxnBufferSize > Config.TXN_BUFFER_SIZE)) {
            clientTxnBufferSize = Config.TXN_BUFFER_SIZE;
        }
        return clientTxnBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean publish(IMgram m, IClientContext sender) throws ETxnSequenceError, ETxnAborted, InterruptedException {
        this.updateLastActivityOnPublish(m);
        if (this.m_state != 0) {
            throw new ETxnSequenceError("publish");
        }
        int clientTxnBufferSize = this.getBufferSize();
        int txSize = this.getTxSize(m, clientTxnBufferSize);
        TxnContentMgr txnContentMgr = this.m_contentMgr;
        synchronized (txnContentMgr) {
            if (this.getOwnerCC() != null && this.getOwnerCC().isXOnce()) {
                this.sendReceiptAcks(m.getGuarenteedTrackingNum(), m.memoryLength());
            }
            if (this.m_msgPersistenceType == 2) {
                if (this.DEBUG) {
                    this.debug("publish mgram (file based): new Tx Size= " + txSize);
                }
                if (Config.LG_ENABLE) {
                    if (m.hasTxn()) {
                        m.removeTxn();
                    }
                    if (m.isPTP() || m.isPubSub() && m.forRemoteNode(Config.ROUTING_NODE_NAME)) {
                        InterceptorManager.doActionalP2PReceiveJointPoint(m, sender);
                    } else {
                        InterceptorManager.doActionalPubSubReceiveJointPoint(m, sender);
                        if (Config.ENABLE_SECURITY && m.isSecure() && InterceptorManager.isMessageLGInstrumented(m)) {
                            try {
                                m.getSecurity();
                                byte attr = s_reg.getMsgProc().handleQopSecurity(m, true, true);
                                m.setSecurityAttribute(attr);
                            }
                            catch (EIntegrityCompromised ex) {
                                this.debug("Exception occurred", ex);
                            }
                        }
                    }
                }
                TxMsg txm = new TxMsg(this.m_tid, this.getOwner(), this.getOwnerCC(), m);
                txm.setOrigTracking(m.getGuarenteedTrackingNum());
                this.m_contentMgr.addMsg(txm);
                return true;
            }
            return false;
        }
    }

    private int getTxSize(IMgram m, int clientTxnBufferSize) throws InterruptedException {
        int txSize;
        if (this.m_contentMgr == null) {
            txSize = m.memoryLength();
            if (!ENABLE_PERSISTENCE_IN_LOG) {
                this.m_contentMgr = new TxnContentMgrFile(this);
                this.m_msgPersistenceType = (byte)2;
            } else if (txSize <= clientTxnBufferSize) {
                this.m_contentMgr = new TxnContentMgrLog(this);
                this.m_msgPersistenceType = 1;
            } else {
                this.m_contentMgr = new TxnContentMgrFile(this);
                this.m_msgPersistenceType = (byte)2;
            }
        } else {
            txSize = this.m_contentMgr.getTotalSize() + m.memoryLength();
            if (this.m_msgPersistenceType != 2 && txSize > clientTxnBufferSize) {
                if (this.DEBUG) {
                    this.debug("publish mgram: Converting to fileBased; new Tx Size= " + txSize);
                }
                TxnContentMgr oldMgr = this.m_contentMgr;
                this.m_contentMgr = new TxnContentMgrFile(this, this.m_contentMgr.getMsgQueue(), this.m_contentMgr.getTotalSize());
                try {
                    ((TxnContentMgrFile)this.m_contentMgr).flush(false, true, false);
                }
                catch (IOException ioe) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
                oldMgr.cancelMsgs();
                this.m_contentMgr.cleanupMemoryQ();
                this.m_msgPersistenceType = (byte)2;
            }
        }
        return txSize;
    }

    private void updateLastActivityOnPublish(IMgram m) {
        if (m.getType() != 27) {
            this.updateLastActiveTime();
        }
    }

    synchronized void addingMsgToLog() throws ETxnSequenceError {
        if (this.m_state != 0) {
            throw new ETxnSequenceError("publish");
        }
        this.m_pendingIncomingMsg = true;
    }

    synchronized void publish(TxMsg m) throws ETxnSequenceError {
        if (this.m_pendingIncomingMsg) {
            this.notifyAll();
        }
        this.m_pendingIncomingMsg = false;
        if (m.getMsg().getType() != 27) {
            this.updateLastActiveTime();
        }
        if (this.m_state != 0) {
            throw new ETxnSequenceError("publish");
        }
        if (this.m_contentMgr == null) {
            throw new EAssertFailure("ContentMgr is null");
        }
        this.m_contentMgr.addMsg(m);
        if (this.DEBUG) {
            this.debug("publish TxMsg: new Tx Size= " + this.m_contentMgr.getTotalSize());
        }
    }

    synchronized void publishRecovered(TxMsg m) throws ETxnSequenceError, ETxnAborted {
        IXOnceHandle xoh;
        if (this.m_state != 1 && this.m_state != 3 && this.m_state != 0 && this.m_state != 8 && this.m_state != 7) {
            throw new ETxnSequenceError("publishRecovered");
        }
        if (this.m_contentMgr == null) {
            if (this.m_msgPersistenceType != 1) {
                throw new EAssertFailure("PublishRecovered: msg; persistence type is not log based ");
            }
            this.m_contentMgr = new TxnContentMgrLog(this);
        }
        this.m_contentMgr.addMsg(m);
        if (this.getOwnerCC() != null && (xoh = this.getOwnerCC().getXOnceHandle()) != null) {
            long trk = m.getOrigTracking();
            this.getOwnerCC().getWindowAckManager().receivedTxnMsg(this.m_tid, trk);
            this.getOwnerCC().getXOnceHandle().addGuarUGA(trk);
        }
        if (this.DEBUG1) {
            this.debug("publishRecovered TxMsg: txstate= " + this.m_state + " new Tx Size= " + this.m_contentMgr.getTotalSize());
        }
    }

    synchronized void resumeTxn() throws ETxnSequenceError, InterruptedException {
        if (this.DEBUG) {
            this.debug("resume as " + this.m_xid);
        }
        if (this.m_state != 8) {
            throw new ETxnSequenceError("resume");
        }
        this.m_requestId = RequestContext.getRequestIdAsLong();
        GlobalTxnResumeEvt evt = new GlobalTxnResumeEvt(this.m_tid, this.m_requestId);
        this.addEventAndWaitForFlush(evt);
        this.m_state = 0;
    }

    synchronized void joinTxn() throws ETxnSequenceError, InterruptedException {
        if (this.DEBUG) {
            this.debug("join as " + this.m_xid);
        }
        if (this.m_state != 7) {
            throw new ETxnSequenceError("join");
        }
        this.m_requestId = RequestContext.getRequestIdAsLong();
        GlobalTxnJoinEvt evt = new GlobalTxnJoinEvt(this.m_tid, this.m_requestId);
        this.addEventAndWaitForFlush(evt);
        this.m_state = 0;
    }

    synchronized void endTxn(Object xid) throws ETxnSequenceError, InterruptedException {
        if (this.DEBUG) {
            this.debug("end as " + xid);
        }
        if (this.m_state != 0 && this.m_state != 8) {
            throw new ETxnSequenceError("end");
        }
        this.m_requestId = RequestContext.getRequestIdAsLong();
        GlobalTxnEndEvt evt = new GlobalTxnEndEvt(this.m_tid, this.m_requestId);
        this.addEventAndWaitForFlush(evt);
        this.m_state = (short)7;
    }

    synchronized void suspendTxn(Object xid) throws ETxnSequenceError, InterruptedException {
        if (this.DEBUG) {
            this.debug("suspend as " + xid);
        }
        if (this.m_state != 0) {
            throw new ETxnSequenceError("suspend");
        }
        this.m_requestId = RequestContext.getRequestIdAsLong();
        GlobalTxnSuspendEvt evt = new GlobalTxnSuspendEvt(this.m_tid, this.m_requestId);
        this.addEventAndWaitForFlush(evt);
        this.m_state = (short)8;
    }

    synchronized void prepare(String xid) throws ETxnSequenceError, ETxnAborted, InterruptedException {
        if (this.DEBUG) {
            this.debug("prepare as " + xid);
        }
        if (this.m_state == 5) {
            throw new ETxnAborted(prAccessor.getString("STR260"));
        }
        if (this.m_state != 0) {
            throw new ETxnSequenceError("prepare");
        }
        this.finalizeMsgsBeforeEventFlush();
        this.m_prepTime = System.currentTimeMillis();
        this.m_userXid = xid;
        TxnPrepareEvt evt = new TxnPrepareEvt(this.m_tid, xid, this.m_prepTime, this.m_ackPool, this.m_msgPersistenceType, RequestContext.getRequestIdAsLong());
        this.andEventAndFlush(evt, (short)1);
    }

    synchronized void prepare() throws ETxnSequenceError, ETxnAborted, InterruptedException {
        if (this.DEBUG) {
            this.debug("XA prepare as " + this.m_xid.toString());
        }
        if (!this.m_XAtxn) {
            throw new ETxnAborted("can not prepare a non-XA transaction");
        }
        if (this.m_state == 1) {
            return;
        }
        if (this.m_state == 5) {
            throw new ETxnAborted(prAccessor.getString("STR260"));
        }
        if (this.m_state != 7 && this.m_state != 8) {
            throw new ETxnSequenceError("prepare");
        }
        this.finalizeMsgsBeforeEventFlush();
        this.m_prepTime = System.currentTimeMillis();
        this.m_requestId = RequestContext.getRequestIdAsLong();
        GlobalTxnPrepareEvt evt = new GlobalTxnPrepareEvt(this.m_tid, this.m_userXid, this.m_xid, this.m_prepTime, this.m_ackPool, this.m_msgPersistenceType, this.m_requestId);
        this.andEventAndFlush(evt, (short)1);
    }

    synchronized void abort() throws ETxnSequenceError, InterruptedException {
        LogEvent evt;
        if (this.DEBUG) {
            this.debug("abort");
        }
        if (this.m_state == 4 || this.m_state == 3) {
            throw new ETxnSequenceError("abort");
        }
        while (this.m_pendingIncomingMsg) {
            if (this.DEBUG1) {
                this.debug("Waiting for Msg");
            }
            this.wait();
        }
        if (this.m_state == 4 || this.m_state == 3) {
            throw new ETxnSequenceError("abort");
        }
        this.m_requestId = RequestContext.getRequestIdAsLong();
        this.m_chained = RequestContext.getChained();
        this.m_replyStatus = RequestContext.getReplyStatus();
        if (this.m_state == 1) {
            if (this.isRecoveredPreparedTxn()) {
                this.sendMsgsBackToQ();
            }
            evt = new TxnAbortBeginEvt(this.m_tid, this.m_requestId, this.m_chained, this.m_replyStatus);
            s_logMgr.addEvent(evt, true);
            s_logMgr.waitForFlush(evt);
        }
        this.clearAckPool();
        if (this.m_contentMgr != null) {
            this.m_contentMgr.cancelMsgs();
            this.m_contentMgr.deleteMsgStore();
        }
        evt = this.m_XAtxn ? new GlobalTxnAbortEvt(this.m_tid, this.m_xid, this.m_requestId, this.m_chained, this.m_replyStatus) : new TxnAbortEvt(this.m_tid, this.m_requestId, this.m_chained, this.m_replyStatus);
        if (this.m_state == 1) {
            s_logMgr.addEvent(evt, false);
        } else if (this.m_state == 6) {
            s_logMgr.addEvent(evt, true);
            s_logMgr.waitForFlush(evt);
        } else {
            this.addEventAndWaitForFlush(evt);
        }
        if (this.m_state != 5) {
            s_txnmgr.incAbortCount();
        }
        this.m_state = (short)5;
        this.notifyAll();
        this.disconnectPendingParticipants();
        if (this.DEBUG1) {
            this.updateCounter();
        }
    }

    private void clearAckPool() {
        if (this.m_ackPool == null) {
            return;
        }
        this.m_ackPool.clear();
        this.m_ackPool = null;
    }

    synchronized void precommit() throws ETxnAborted, ETxnSequenceError, InterruptedException {
        boolean logPrecommitEvent = true;
        if (this.DEBUG) {
            this.debug("precommit");
        }
        if (this.m_state == 5) {
            throw new ETxnAborted(prAccessor.getString("STR261"));
        }
        if (this.m_state == 4 || this.m_state == 3) {
            throw new ETxnSequenceError("precommit");
        }
        if (this.m_XAtxn) {
            if (this.m_state == 0) {
                throw new ETxnSequenceError("precommit");
            }
            this.checkAndFinalizeMsgsBeforeEventFlush((short)7, (short)8);
        }
        this.checkAndFinalizeMsgsBeforeEventFlush((short)0, (short)6);
        this.m_requestId = RequestContext.getRequestIdAsLong();
        this.m_chained = RequestContext.getChained();
        TxnPrecommitEvt pce = this.m_XAtxn ? new GlobalTxnPrecommitEvt(this.m_tid, this.m_xid, this.m_ackPool, this.m_msgPersistenceType, this.m_requestId) : new TxnPrecommitEvt(this.m_tid, this.m_ackPool, this.m_msgPersistenceType, this.m_requestId, this.m_chained);
        this.andEventAndFlush(pce, (short)3);
    }

    private <T0 extends LogEvent> void andEventAndFlush(T0 evt, short PREPARED) throws InterruptedException {
        s_logMgr.addEvent(evt, true);
        s_logMgr.waitForFlush(evt);
        this.finalizeMsgsAfterEventFlush();
        this.m_state = PREPARED;
    }

    private void checkAndFinalizeMsgsBeforeEventFlush(short state1, short state2) throws ETxnAborted, InterruptedException {
        if (this.m_state == state1 || this.m_state == state2) {
            this.finalizeMsgsBeforeEventFlush();
        }
    }

    synchronized void join() throws InterruptedException {
        while (this.m_state != 4 && this.m_state != 5) {
            this.wait();
        }
    }

    synchronized void commit(boolean recommit) throws ETxnSequenceError, ETxnCommitPublishFailed, InterruptedException {
        if (this.DEBUG) {
            this.debug("commit; lastMsgSeq= " + this.m_lastMsgSeqPublish);
        }
        if (recommit && (this.debugFlags & 0x1000) > 0) {
            this.debug("recommitting ");
        }
        if (this.m_state != 3) {
            throw new ETxnSequenceError("commit");
        }
        try {
            int count;
            if (this.m_contentMgr != null) {
                if (this.DEBUG1) {
                    count = this.m_contentMgr.getMsgQueue().count();
                    if (recommit && count > 0) {
                        this.debug("Recommitting " + count + " messages");
                    }
                }
                this.m_contentMgr.commitMsgs(this.m_lastMsgSeqPublish, recommit);
            }
            if (this.m_ackPool != null) {
                if (this.DEBUG1) {
                    count = this.m_ackPool.getCount();
                    if (recommit && count > 0) {
                        this.debug("Recommitting " + count + " acks");
                    }
                }
                this.m_ackPool.commitAcks(this);
                if (recommit) {
                    this.m_ackPool.markAcksRecommitted(s_txnmgr);
                }
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new ETxnCommitPublishFailed(null, (Throwable)e);
        }
        this.m_requestId = RequestContext.getRequestIdAsLong();
        this.m_chained = RequestContext.getChained();
        TxnCommitEvt tce = this.m_XAtxn ? new GlobalTxnCommitEvt(this.m_tid, this.m_xid, this.m_requestId) : new TxnCommitEvt(this.m_tid, this.m_requestId, this.m_chained);
        boolean flushed = false;
        if (this.m_XAtxn || this.m_msgPersistenceType == 2) {
            s_logMgr.addEvent(tce, true);
            s_logMgr.waitForFlush(tce);
            flushed = true;
        } else {
            this.addEventAndWaitForFlush(tce);
        }
        s_txnmgr.incCommitCount();
        if (flushed) {
            this.clearAckPool();
        } else {
            this.m_ackPool = null;
        }
        this.deleteMsgStoreCheckingNull();
        this.m_state = (short)4;
        this.notifyAll();
        this.disconnectPendingParticipants();
        if (this.DEBUG) {
            this.debug("Commit completed");
        }
        if (this.DEBUG1) {
            this.updateCounter();
        }
    }

    private void addEventAndWaitForFlush(LogEvent tce) throws InterruptedException {
        s_logMgr.addEvent(tce, true);
        if (RequestContext.getXonce()) {
            s_logMgr.waitForFlush(tce);
        }
    }

    void commitAckMsg(IMgram m) throws ETxnCommitPublishFailed {
        IClientContext commitCC;
        block9: {
            if (this.DEBUG) {
                this.debug("commit: Acknowledging " + m.getAckHandle().getTrackingNumber() + " m_owner= " + this.getOwner() + " clientId from ack= " + m.getAckHandle().getClientID());
            }
            commitCC = this.m_ownerCtx;
            try {
                if (this.m_ownerCtx == null) {
                    commitCC = this.m_ownerCtx = s_reg.getClient(this.getOwner());
                }
            }
            catch (EClientNotRegistered e) {
                long clientID = m.getAckHandle().getClientID();
                if (clientID == -1L) break block9;
                try {
                    commitCC = s_reg.getClient(clientID);
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    // empty catch block
                }
            }
        }
        if (commitCC == null) {
            return;
        }
        try {
            commitCC.txnAcknowledge(m.getAckHandle().getTrackingNumber(), m);
        }
        catch (Exception e) {
            throw new ETxnCommitPublishFailed(null, (Throwable)e);
        }
    }

    void recoverAckParticipant(IMgram m) {
        s_txnmgr.registerTxnParticipant(m.getAckHandle().getClientID(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addParticipant(Long participantID) {
        if (this.m_participants == null) {
            this.m_participants = new Vector();
        }
        Vector vector = this.m_participants;
        synchronized (vector) {
            if (!this.m_participants.contains(participantID)) {
                this.m_participants.addElement(participantID);
            }
        }
        if (this.DEBUG) {
            this.debug("add " + participantID + "; $$$ m_participants=" + this.m_participants.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeParticipant(Long participantID) {
        if (this.m_participants == null) {
            return;
        }
        Vector vector = this.m_participants;
        synchronized (vector) {
            this.m_participants.removeElement(participantID);
        }
        if (this.DEBUG) {
            this.debug("remove " + participantID + "; $$$ m_participants=" + this.m_participants.toString());
        }
    }

    private void disconnectPendingParticipants() {
        if (this.m_participants == null) {
            return;
        }
        Enumeration participants = ((Vector)this.m_participants.clone()).elements();
        while (participants.hasMoreElements()) {
            Long pid = (Long)participants.nextElement();
            this.removeParticipant(pid);
            s_txnmgr.unregisterTxnParticipant(pid, this);
        }
    }

    boolean isOwner(int uid) {
        return AddrUtil.clientIdToUid(this.getOwner()) == uid;
    }

    boolean isAuthenticatedXAUser(long clientId) throws EClientNotRegistered {
        if (!Config.ENABLE_SECURITY) {
            return true;
        }
        if (this.isOwner(AddrUtil.clientIdToUid(clientId))) {
            return true;
        }
        ClientSecurityContext csc = s_reg.getClientSecurityContext(clientId);
        ProgressGroup txnAdminGroup = s_reg.getSecurityBean().getGroup("TxnAdministrators");
        return txnAdminGroup.isMember(csc.getPrincipal());
    }

    void flushMsgs() throws ETxnAborted, InterruptedException {
        try {
            this.m_contentMgr.flushMsgs();
        }
        catch (IOException e) {
            Transaction transaction = this;
            synchronized (transaction) {
                try {
                    this.abort();
                }
                catch (ETxnSequenceError ee) {
                    throw new EAssertFailure("Error aborting transaction " + this.m_tid + " in flush(): " + ee, ee);
                }
                this.notifyAll();
                throw new ETxnAborted(e.toString());
            }
        }
    }

    private void finalizeMsgsBeforeEventFlush() throws ETxnAborted, InterruptedException {
        if (this.m_state == 5) {
            throw new ETxnAborted("finalizeTxnFile()");
        }
        try {
            if (this.m_contentMgr != null) {
                this.m_contentMgr.finalizeMsgsBeforeEventFlush();
            }
            this.callBackTransactionFinalized();
        }
        catch (IOException e) {
            RequestContext.setReplyStatus((short)4);
            try {
                this.abort();
            }
            catch (ETxnSequenceError ee) {
                BrokerComponent.getComponentContext().logMessage(ee + " in Transaction.finalizeTxnFile()", 2);
            }
            throw new ETxnAborted(e.toString());
        }
    }

    private void finalizeMsgsAfterEventFlush() {
        if (this.m_contentMgr != null) {
            this.m_contentMgr.finalizeMsgsAfterEventFlush();
        }
        this.callBackTransactionFinalized();
    }

    private void callBackTransactionFinalized() {
        if (this.CALLBACK) {
            this.callback("Transaction Finalized", 0, null);
        }
    }

    static File getTxnFileName(String prefix, int tid) {
        return new File(prefix + tid);
    }

    static File getTxnFileName(int tid) {
        return Transaction.getTxnFileName(Config.TXN_FILE_FULLPATH_PREFIX, tid);
    }

    synchronized void closeTxnFile() {
        if (this.m_contentMgr != null) {
            this.m_contentMgr.closeMsgStore();
        }
    }

    synchronized void setInDoubtReqPending(int tracking) {
        this.m_inDoubtReqPending = true;
        this.m_inDoubtReqTracking = tracking;
    }

    synchronized Integer getInDoubtReqTracking() {
        if (this.m_inDoubtReqPending) {
            return new Integer(this.m_inDoubtReqTracking);
        }
        return null;
    }

    synchronized void cancelInDoubtReq() {
        this.m_inDoubtReqPending = false;
    }

    synchronized void writeSyncRecord() throws ECannotFlushEvents {
        if (this.isXAtransaction()) {
            s_logMgr.tryAddEvent(new GlobalTxnSyncEvt(this.m_tid, this.m_ownerUid, this.m_ownerAppid, this.m_state, this.m_userXid, this.m_noDupCommitId, this.m_noDupTimestamp, this.m_xid, this.m_ackPool, this.m_msgPersistenceType, this.m_requestId, this.m_lifespan, this.m_chained, this.m_replyStatus), false);
        } else if (this.isChannel()) {
            s_logMgr.tryAddEvent(new ChannelTxnSyncEvt(this.m_tid, this.m_previousTid, this.m_ownerUid, this.m_ownerAppid, this.m_state, this.m_userXid, this.m_noDupCommitId, this.m_noDupTimestamp, this.m_channelId, this.m_channelStatus, this.m_ackPool, this.m_msgPersistenceType, this.m_requestId, this.m_lifespan, this.m_chained, this.m_replyStatus), false);
        } else {
            s_logMgr.tryAddEvent(new SyncTxnEvt(this.m_tid, this.m_previousTid, this.m_ownerUid, this.m_ownerAppid, this.m_state, this.m_userXid, this.m_noDupCommitId, this.m_noDupTimestamp, this.m_ackPool, this.m_msgPersistenceType, this.m_requestId, this.m_lifespan, this.m_chained, this.m_replyStatus), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendStorageAcks(long[] backTrackings, boolean sendNow) {
        if (this.getOwnerCC() == null || !this.getOwnerCC().isXOnce()) {
            return false;
        }
        if (this.m_state != 0) {
            if (this.DEBUG && backTrackings != null && backTrackings.length > 0) {
                this.debug("sendStorageAcks(): discarding " + backTrackings.length + " storage ack(s), ack[0] = " + backTrackings[0] + ", txn state = " + this.m_state);
            }
            return true;
        }
        Object object = this.m_windowedAckLock;
        synchronized (object) {
            if (this.m_pendingStorageAcks == null) {
                this.m_pendingStorageAcks = new ArrayList();
            }
            if (backTrackings != null && backTrackings.length > 0) {
                if (this.DEBUG) {
                    StringBuffer ackList = new StringBuffer();
                    for (int i = 0; i < backTrackings.length; ++i) {
                        ackList.append(backTrackings[i] + "\t");
                    }
                    this.debug("sendStorageAcks(): adding " + backTrackings.length + " storage ack(s) to pending storage ack list, ack(s) = " + ackList.toString());
                }
                for (int i = 0; i < backTrackings.length; ++i) {
                    this.m_pendingStorageAcks.add(new Long(backTrackings[i]));
                    this.m_receiptAcksPendingStorageAck.remove(backTrackings[i]);
                }
            }
            if (this.m_pendingStorageAcks.isEmpty()) {
                return true;
            }
            int index = -1;
            index = this.m_pendingStorageAcks.indexOf(new Long(this.m_lastSentStorageAck));
            if (index != -1) {
                this.m_pendingStorageAcks.subList(0, ++index).clear();
            }
            if (this.m_pendingStorageAcks.isEmpty()) {
                return true;
            }
            if (sendNow) {
                int count;
                long[] storageTrackings = backTrackings;
                if (storageTrackings == null) {
                    storageTrackings = new long[]{};
                }
                if (storageTrackings.length != (count = this.m_pendingStorageAcks.size())) {
                    storageTrackings = new long[count];
                    this.fillStorageTrackings(count, storageTrackings);
                }
                this.m_lastSentStorageAck = storageTrackings[count - 1];
                long pendingReceiptAck = this.m_pendingReceiptAck;
                this.m_pendingReceiptAck = -1L;
                if (this.DEBUG) {
                    this.debug("sendStorageAcks(): sending window ack, receipt ack tracking = " + pendingReceiptAck + ", storage ack tracking = " + this.m_lastSentStorageAck + ", total storage ack count = " + storageTrackings.length);
                }
                this.m_ownerCtx.getWindowAckManager().sendWindowAck(this.m_tid, pendingReceiptAck, storageTrackings);
            }
            return true;
        }
    }

    void checkForGoodTxnFileContent() {
        TxnContentMgrFile cmgr = new TxnContentMgrFile(this);
        boolean validFileContent = false;
        try {
            validFileContent = cmgr.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (validFileContent) {
            this.m_msgPersistenceType = (byte)2;
            this.m_contentMgr = cmgr;
        } else {
            cmgr.deleteMsgStore();
            this.m_msgPersistenceType = 0;
        }
    }

    List<Long> getReceiptAcksPendingStorageAck() {
        return this.m_receiptAcksPendingStorageAck;
    }

    void clearReceiptAcksPendingStorageAck() {
        this.m_receiptAcksPendingStorageAck.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendReceiptAcks(long receiptTracking, int msgSize) throws ETxnAborted {
        if (this.getOwnerCC() == null || !this.getOwnerCC().isXOnce()) {
            return false;
        }
        this.m_ownerCtx.getWindowAckManager().receivedTxnMsg(this.m_tid, receiptTracking);
        this.m_receiptAcksPendingStorageAck.add(receiptTracking);
        Object object = this.m_windowedAckLock;
        synchronized (object) {
            if (this.m_pendingReceiptAck != -1L) {
                throw new ETxnAborted("Message " + receiptTracking + " received while receipt ack " + this.m_pendingReceiptAck + " pending");
            }
            if (this.m_contentMgr.getMemoryQsize() + msgSize > this.getBufferSize()) {
                if (this.DEBUG) {
                    this.debug("sendReceiptAcks(" + receiptTracking + "): receipt ack pending txn buffer flush");
                }
                this.m_pendingReceiptAck = receiptTracking;
                return true;
            }
            if (this.m_pendingStorageAcks == null || this.m_pendingStorageAcks.isEmpty()) {
                if (this.DEBUG) {
                    this.debug("sendReceiptAcks(" + receiptTracking + "): sending window ack, no storage available");
                }
                this.m_ownerCtx.getWindowAckManager().sendWindowAck(this.m_tid, receiptTracking, null);
                return true;
            }
            int count = this.m_pendingStorageAcks.size();
            long[] storageTrackings = new long[count];
            this.fillStorageTrackings(count, storageTrackings);
            this.m_lastSentStorageAck = storageTrackings[count - 1];
            if (this.DEBUG) {
                this.debug("sendReceiptAcks(" + receiptTracking + "): sending window ack, storage ack tracking = " + this.m_lastSentStorageAck + ", total storage ack count = " + storageTrackings.length);
            }
            this.m_ownerCtx.getWindowAckManager().sendWindowAck(this.m_tid, receiptTracking, storageTrackings);
            return true;
        }
    }

    private void fillStorageTrackings(int count, long[] storageTrackings) {
        for (int i = 0; i < count; ++i) {
            storageTrackings[i] = (Long)this.m_pendingStorageAcks.remove(0);
        }
    }

    void redoPrepare(TxnPrepareEvt evt, boolean cloneAcks) {
        this.m_userXid = evt.getUserXid();
        this.m_prepTime = evt.getTime();
        this.m_ackPool = cloneAcks && evt.getTxnAckPool() != null ? evt.getTxnAckPool().makeCopy(this.m_tid) : evt.getTxnAckPool();
        this.m_msgPersistenceType = evt.getPersistenceType();
        this.m_state = 1;
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoPrepare; persistType= " + this.m_msgPersistenceType);
        }
    }

    void redoJoin(GlobalTxnJoinEvt evt) {
        this.m_state = 0;
        this.m_requestId = evt.getRequestId();
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoJoin");
        }
    }

    void redoSuspend(GlobalTxnSuspendEvt evt) {
        this.m_state = (short)8;
        this.m_requestId = evt.getRequestId();
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoSuspend");
        }
    }

    void redoResume(GlobalTxnResumeEvt evt) {
        this.m_state = 0;
        this.m_requestId = evt.getRequestId();
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoResume");
        }
    }

    void redoEnd(GlobalTxnEndEvt evt) {
        this.m_state = (short)7;
        this.m_requestId = evt.getRequestId();
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoEnd");
        }
    }

    void redoPrecommit(TxnPrecommitEvt evt, boolean cloneAcks) {
        this.m_ackPool = cloneAcks && evt.getTxnAckPool() != null ? evt.getTxnAckPool().makeCopy(this.m_tid) : evt.getTxnAckPool();
        this.m_msgPersistenceType = evt.getPersistenceType();
        this.m_requestId = evt.getRequestId();
        this.m_chained = evt.getChained();
        this.m_state = (short)3;
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoPrecommit; persistType= " + this.m_msgPersistenceType);
        }
    }

    void redoCommit(TxnCommitEvt evt) {
        this.initContentMgr();
        this.deleteMsgStoreCheckingNull();
        this.clearAckPool();
        this.m_requestId = evt.getRequestId();
        this.m_chained = evt.getChained();
        this.m_state = (short)4;
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoCommit; persistType= " + this.m_msgPersistenceType + " contentMgr= " + this.m_contentMgr);
        }
    }

    private void deleteMsgStoreCheckingNull() {
        if (this.m_contentMgr != null) {
            this.m_contentMgr.deleteMsgStore();
        }
    }

    void redoAbort(TxnAbortEvt evt) {
        this.deleteMsgStoreTypes();
        this.clearAckPool();
        this.m_state = (short)5;
        this.m_requestId = evt.getRequestId();
        this.m_chained = evt.getChained();
        this.m_replyStatus = evt.getReason();
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoAbort; ");
        }
    }

    void redoAbortBegin(TxnAbortBeginEvt evt) {
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("RedoAbortBegin ");
        }
        this.m_state = (short)5;
        this.m_requestId = evt.getRequestId();
        this.m_chained = evt.getChained();
        this.m_replyStatus = evt.getReason();
        this.m_state = (short)5;
    }

    void undo() {
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("Undoing ");
        }
        this.deleteMsgStoreTypes();
    }

    private void deleteMsgStoreTypes() {
        TxnContentMgr contentMgr = new TxnContentMgrLog(this);
        contentMgr.deleteMsgStore();
        contentMgr = new TxnContentMgrFile(this);
        contentMgr.deleteMsgStore();
    }

    void initializeRuntimeState() {
        if (this.m_msgPersistenceType == 0) {
            this.m_msgPersistenceType = !ENABLE_PERSISTENCE_IN_LOG ? (byte)2 : (byte)1;
        }
        this.initContentMgr();
        s_txnmgr.registerTxnParticipant(this.m_owner, this);
        if (this.m_ackPool != null) {
            this.m_ackPool.recoverParticipants(this);
        }
    }

    synchronized void writeAdminInfo(DataOutput out) throws IOException {
        out.writeInt(this.m_tid);
        String xid = this.m_userXid == null ? "" : this.m_userXid;
        out.writeUTF(xid);
        out.writeUTF(this.m_ownerUid);
        out.writeUTF(this.m_ownerAppid);
        out.writeLong(this.m_prepTime);
    }

    synchronized void startNoDupCommit(String transactionId, long noDupTimestamp, boolean isChannel, int channelStatus, String channelId, long lifespan, long requestId, boolean chained) {
        this.m_noDupCommitId = transactionId;
        this.m_state = (short)6;
        this.m_noDupTimestamp = noDupTimestamp;
        this.m_isChannel = isChannel;
        this.m_channelStatus = channelStatus;
        this.m_channelId = channelId;
        this.m_lifespan = lifespan;
        this.m_requestId = requestId;
        this.m_chained = chained;
    }

    synchronized void undoNoDupCommitBegin() throws ETxnSequenceError {
        if (this.m_state != 6) {
            throw new ETxnSequenceError("undoNoDupCommitBegin");
        }
        this.m_state = 0;
    }

    synchronized long getNoDupTimestamp() {
        return this.m_noDupTimestamp;
    }

    @Override
    public synchronized long getExpirationTime() {
        return this.m_lastActiveTime + (long)this.m_idleTimeOut;
    }

    @Override
    public void timeOutExpired() throws InterruptedException {
        s_txnmgr.addTimeOutOp(this);
    }

    public void setDoNotReplicateLive(boolean doNotReplicateLive) {
        this.m_doNotReplicateLive = doNotReplicateLive;
    }

    public boolean getDoNotReplicateLive() {
        return this.m_doNotReplicateLive;
    }

    public synchronized void replicateFile() throws IOException {
        if (this.m_contentMgr != null) {
            this.m_contentMgr.replicate();
        }
        this.setDoNotReplicateLive(false);
    }

    private void initContentMgr() {
        if (this.m_msgPersistenceType == 0) {
            return;
        }
        if (this.m_msgPersistenceType == 1) {
            if (this.m_contentMgr == null) {
                this.m_contentMgr = new TxnContentMgrLog(this);
            }
        } else if (this.m_msgPersistenceType == 2) {
            if (this.m_contentMgr == null) {
                this.m_contentMgr = new TxnContentMgrFile(this);
            }
        } else {
            throw new EAssertFailure("Undefined content mgr");
        }
    }

    byte getPersistenceType() {
        return this.m_msgPersistenceType;
    }

    private void updateCounter() {
        if (this.DEBUG1) {
            ++tx_tot;
            if (this.m_msgPersistenceType == 2) {
                ++type_file;
            }
            if (this.m_msgPersistenceType == 1) {
                ++type_log;
            }
            if (this.m_msgPersistenceType == 0) {
                ++type_none;
            }
            if (tx_tot % 1000 == 0) {
                this.debug("TotTx= " + tx_tot + " PersistLog= " + type_log + " PersistFile= " + type_file + " PersistNone= " + type_none);
            }
        }
    }

    static {
        s_mp = null;
        try {
            s_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (ClassNotFoundException ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
        }
        catch (IllegalAccessException ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
        }
        catch (InstantiationException ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
        }
    }
}

