/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class TxnAbortBeginEvt
extends LogEvent {
    private int m_tid;
    private long m_requestId;
    private boolean m_chained;
    private short m_type = (short)87;
    private short m_reason = 0;

    TxnAbortBeginEvt(int tid, long requestId, boolean chained, short reason) {
        this.m_tid = tid;
        this.m_requestId = requestId;
        this.m_chained = chained;
        this.m_reason = reason;
    }

    TxnAbortBeginEvt(short type) {
        this.m_type = type;
    }

    int getTid() {
        return this.m_tid;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    boolean getChained() {
        return this.m_chained;
    }

    short getReason() {
        return this.m_reason;
    }

    @Override
    public short type() {
        return 87;
    }

    @Override
    protected int memSizeBody() {
        return 15;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 15;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeInt(this.m_tid, out);
        StreamUtil.writeLong(this.m_requestId, out);
        StreamUtil.writeBoolean(this.m_chained, out);
        StreamUtil.writeShort(this.m_reason, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeLong(this.m_requestId, os);
        StreamUtil.writeBoolean(this.m_chained, os);
        StreamUtil.writeShort(this.m_reason, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        if (this.m_type == 87) {
            this.m_requestId = StreamUtil.readLong(in);
            this.m_chained = StreamUtil.readBoolean(in);
            this.m_reason = StreamUtil.readShort(in);
        } else {
            this.m_requestId = 0L;
            this.m_chained = false;
            this.m_reason = 0;
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTxnAbortBegin(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Txn " + this.m_tid + ", requestId " + this.m_requestId + ", chained " + this.m_chained + ", reason " + this.m_reason + ": abort begin";
    }
}

