/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ETxnCommitPublishFailed;
import progress.message.broker.IAgentQueue;
import progress.message.broker.QueueMsgSaver;
import progress.message.broker.Transaction;
import progress.message.broker.TransactionMgr;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.StreamUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;

public class TxnAckPool
extends DebugObject {
    private Vector m_pool = new Vector();
    private int m_memorySize = 0;
    private int m_serializedSize = 0;

    TxnAckPool(int tid) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TxnAckPool " + tid : null);
    }

    int getCount() {
        return this.m_pool.size();
    }

    void add(IMgram ack) {
        this.m_pool.add(ack);
        this.m_memorySize += ack.memoryLength();
        this.m_serializedSize += ack.serializedLength();
        if (this.DEBUG) {
            this.debug("add " + ack.getClass().getName() + " size= " + this.m_pool.size() + " memory size= " + this.m_memorySize + " serialized size= " + this.m_serializedSize);
        }
    }

    Hashtable getMsgTrackings() {
        Hashtable<Long, String> msgTrackings = new Hashtable<Long, String>();
        Enumeration enu = this.m_pool.elements();
        while (enu.hasMoreElements()) {
            IMgram ack = (IMgram)enu.nextElement();
            long tracking = ack.getAckHandle().getTrackingNumber();
            if (this.DEBUG) {
                this.debug("tracking = " + tracking);
            }
            msgTrackings.put(new Long(tracking), "");
        }
        if (this.DEBUG) {
            this.debug("total msgTrackings = " + msgTrackings.size());
        }
        return msgTrackings;
    }

    void sendMsgsBackToQ(TransactionMgr txnmgr, int tid) {
        IndexedList<IMgram> mgrams = new IndexedList<IMgram>();
        QueueMsgSaver qmsgSaver = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver();
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        boolean isPubSub = false;
        IMgram firstMgramInCurrentQ = null;
        IAgentQueue iaq = null;
        Enumeration enu = this.m_pool.elements();
        while (enu.hasMoreElements()) {
            IMgram ack = (IMgram)enu.nextElement();
            long tracking = ack.getAckHandle().getTrackingNumber();
            String qname = txnmgr.getLocalQueueName(tid, tracking);
            IMgram m = null;
            if (qname == null) {
                if (this.DEBUG) {
                    this.debug("qname is NULL");
                }
            } else {
                if (this.DEBUG) {
                    this.debug("qname = " + qname);
                }
                if ((m = qmsgSaver.retrieveMgram(qname, tracking)) != null) {
                    m.getBrokerHandle().setLocalQueueName(qname);
                }
            }
            if (m == null) {
                if (!this.DEBUG) continue;
                this.debug("Retrieving prepared messages from queue: No mgram in db for tracking " + tracking + " It might be a pubsub message or a non-persistent message");
                continue;
            }
            if (firstMgramInCurrentQ == null) {
                firstMgramInCurrentQ = m;
            }
            if (firstMgramInCurrentQ.isPubSub() && m.isPubSub() || firstMgramInCurrentQ.getSubject().equals(m.getSubject())) {
                mgrams.appendNoDup(tracking, m);
                continue;
            }
            iaq = aqp.resolveQueue(firstMgramInCurrentQ);
            iaq.restore(mgrams, true, true);
            mgrams = new IndexedList();
            firstMgramInCurrentQ = m;
            mgrams.appendNoDup(tracking, m);
        }
        if (mgrams.count() > 0) {
            iaq = aqp.resolveQueue(firstMgramInCurrentQ);
            iaq.restore(mgrams, true, true);
        }
    }

    void markAcksRecommitted(TransactionMgr txnmgr) {
        Enumeration enu = this.m_pool.elements();
        while (enu.hasMoreElements()) {
            IMgram ack = (IMgram)enu.nextElement();
            long tracking = ack.getAckHandle().getTrackingNumber();
            txnmgr.setAckRecomitted(tracking);
        }
    }

    void commitAcks(Transaction txn) throws ETxnCommitPublishFailed {
        Enumeration enu = this.m_pool.elements();
        while (enu.hasMoreElements()) {
            txn.commitAckMsg((IMgram)enu.nextElement());
        }
    }

    void recoverParticipants(Transaction txn) {
        Enumeration enu = this.m_pool.elements();
        while (enu.hasMoreElements()) {
            txn.recoverAckParticipant((IMgram)enu.nextElement());
        }
    }

    void clear() {
        this.m_pool.clear();
        this.m_memorySize = 0;
        this.m_serializedSize = 0;
    }

    int getMemorySize() {
        return this.m_memorySize;
    }

    int getSerializedSize() {
        return this.m_serializedSize + 4;
    }

    void writebody(OutputStream out) throws IOException {
        int ct = this.m_pool.size();
        if (this.DEBUG) {
            this.debug("writing " + ct + " acks");
        }
        StreamUtil.writeInt(ct, out);
        Enumeration enu = this.m_pool.elements();
        int ctw = 0;
        while (enu.hasMoreElements()) {
            ((IMgram)enu.nextElement()).writeMgramToStream(out);
            ++ctw;
        }
        if (this.checkDebugFlags(64) && ctw != ct) {
            this.debug("TxnAckPool: writeBody: ct= " + ct + " ctw= " + ctw + " " + Thread.currentThread().getName());
        }
    }

    public void readBody(InputStream in) throws IOException {
        int ct = StreamUtil.readInt(in);
        if (this.DEBUG) {
            this.debug("reading " + ct + " acks");
        }
        for (int i = 0; i < ct; ++i) {
            try {
                IMgram ack = MgramFactory.getMgramFactory().createMgram(in);
                this.add(ack);
                continue;
            }
            catch (EMgramVersionMismatch ex2) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex2, 2);
                continue;
            }
            catch (EMgramFormatError ex1) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex1, 2);
            }
        }
    }

    TxnAckPool makeCopy(int tid) {
        TxnAckPool acks = new TxnAckPool(tid);
        acks.m_memorySize = this.m_memorySize;
        acks.m_serializedSize = this.m_serializedSize;
        acks.m_pool = (Vector)this.m_pool.clone();
        return acks;
    }
}

