/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import progress.message.broker.IClientContext;
import progress.message.broker.Transaction;
import progress.message.broker.TxnContentMgr;
import progress.message.util.DebugState;

class TxnContentMgrLog
extends TxnContentMgr {
    TxnContentMgrLog(Transaction t) {
        super(t);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("TxnContentMgrLog " + t.getTid());
        }
    }

    @Override
    void commitMsgs(int lastMsgSeqNo, boolean retry) throws Exception {
        super.commitMsgs(0, retry);
    }

    @Override
    void finalizeMsgsAfterEventFlush() {
        IClientContext owner = this.m_transaction.getOwnerCC();
        if (owner != null && owner.isXOnce()) {
            ArrayList<Long> pendingStorageAcks = new ArrayList<Long>(this.m_transaction.getReceiptAcksPendingStorageAck());
            long[] backTrackings = new long[pendingStorageAcks.size()];
            int count = 0;
            for (Long tracking : pendingStorageAcks) {
                backTrackings[count++] = tracking;
            }
            this.m_transaction.clearReceiptAcksPendingStorageAck();
            this.m_transaction.sendStorageAcks(backTrackings, true);
        }
    }
}

