/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.File;
import java.io.IOException;
import progress.message.broker.BlockBuffer;
import progress.message.broker.EChecksumError;
import progress.message.broker.RandomAccessBlockFile;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class UnbufferedFile
extends DebugObject {
    private String m_filename;
    private int m_blocksize;
    private RandomAccessBlockFile m_file;
    private boolean m_closed;

    public UnbufferedFile(String filename) throws IOException {
        super(DebugState.GLOBAL_DEBUG_ON ? filename : null);
        this.m_filename = filename;
        this.m_file = new RandomAccessBlockFile(this.m_filename, "rw");
        UnbufferedFile unbufferedFile = this;
        this.m_blocksize = unbufferedFile.m_file.getBlockSize();
        this.m_closed = false;
    }

    public UnbufferedFile(File file) throws IOException {
        this(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(BlockBuffer buf) throws IOException {
        BlockBuffer blockBuffer = buf;
        synchronized (blockBuffer) {
            if (this.DEBUG) {
                this.debug("reading block");
            }
            int ret = this.m_file.read(buf.getBuffer(), 0, this.m_blocksize);
            if (this.DEBUG) {
                this.debug("return val is " + ret);
            }
            if (ret > 0 && !buf.checksumOk()) {
                throw new EChecksumError(this.m_filename);
            }
            if (ret > 0) {
                ret = 0;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BlockBuffer buf) throws IOException {
        BlockBuffer blockBuffer = buf;
        synchronized (blockBuffer) {
            if (this.DEBUG) {
                this.debug("writing block");
            }
            buf.writeChecksum();
            this.m_file.write(buf.getBuffer(), 0, this.m_blocksize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mirroredWrite(BlockBuffer buf) throws IOException {
        BlockBuffer blockBuffer = buf;
        synchronized (blockBuffer) {
            if (this.DEBUG) {
                this.debug("mirrored write");
            }
            buf.writeChecksum();
            buf.mirror();
            this.m_file.write(buf.getBuffer());
        }
    }

    public void seek(int blockno) throws IOException {
        if (this.DEBUG) {
            this.debug("seeking to block " + blockno + ", handle is " + this.m_file);
        }
        this.m_file.seek(blockno);
    }

    public void seekEnd() throws IOException {
        this.m_file.seek(-1L);
    }

    public int getBlockNo() throws IOException {
        return (int)this.m_file.getBlockNumber();
    }

    public void setEOF() throws IOException {
        this.m_file.truncate();
    }

    public void close() throws IOException {
        if (!this.m_closed) {
            this.m_file.close();
        }
        this.m_closed = true;
    }
}

