/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class UnfilteredEvt
extends LogEvent {
    private long m_id;
    private boolean m_unfiltered;
    private long m_lastSeqNumToFilter = -1L;

    UnfilteredEvt(long id, boolean unfiltered) {
        this.m_id = id;
        this.m_unfiltered = unfiltered;
    }

    UnfilteredEvt() {
    }

    @Override
    public short type() {
        return 43;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    protected int memSizeBody() {
        return 17;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 17;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeBoolean(this.m_unfiltered, os);
        StreamUtil.writeLong(this.m_lastSeqNumToFilter, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_unfiltered = StreamUtil.readBoolean(in);
        this.m_lastSeqNumToFilter = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoUnfiltered(this.m_id, this.m_unfiltered);
    }

    @Override
    public String toString() {
        return super.toString() + " id: " + this.m_id;
    }
}

