/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class UnregisterEvt
extends LogEvent {
    private long m_id;

    UnregisterEvt(long id) {
        this.m_id = id;
    }

    UnregisterEvt() {
    }

    @Override
    public short type() {
        return 20;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeLong(this.m_id, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoUnregister(this.m_id);
    }

    @Override
    public String toString() {
        return super.toString() + "Unregister id: " + this.m_id;
    }
}

