/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.CheckUnsubscribeDurable;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.IClientContext;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EUserAlreadyConnected;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

final class UnsubscribeDurable
implements IMessageHandler {
    private AgentRegistrar m_reg;

    UnsubscribeDurable(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message msg = env.getMessage();
            long uid = (long)AddrUtil.getUidFromAdmin(msg.getSubject()) & 0xFFFFFFFFL;
            String name = msg.readUTF();
            String clientId = msg.readUTF();
            IClientContext cc = CheckUnsubscribeDurable.findDurableClient(uid, clientId, name);
            BrokerSubscription bs = cc.getDurableBrokerSubscription();
            ISubject subject = null;
            if (bs == null) {
                throw new EClientNotRegistered(cc.getId());
            }
            subject = bs.getSubject();
            UnsubscribeEvt evt = new UnsubscribeEvt(env, cc.getId(), subject, null, this);
            this.m_reg.unsubscribe(evt, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (EInvalidApplicationId e) {
            UnsubscribeDurable.sendReply(env, e.getErrorId());
        }
        catch (EClientNotRegistered ecnr) {
            UnsubscribeDurable.sendReply(env, 157);
        }
        catch (EUserAlreadyConnected euac) {
            UnsubscribeDurable.sendReply(env, euac.getErrorId());
        }
        catch (EInvalidAdminAddress eiaa) {
            UnsubscribeDurable.sendReply(env, eiaa.getErrorId());
        }
        catch (EGeneralException e) {
            UnsubscribeDurable.sendReply(env, e.getErrorId());
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (IOException e) {
            UnsubscribeDurable.sendReply(env, -40);
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    static void sendReply(Envelope req, int response) {
        block2: {
            try {
                Message rep = new Message();
                rep.write(response);
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, req, false);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR271") + e.getMessage(), (Throwable)e, 2);
            }
        }
    }
}

