/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.UnsubscribeEvt;
import progress.message.client.EGeneralException;
import progress.message.util.WrappedDataInputStream;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.Subject;

final class UnsubscribeP28
implements IMessageHandler {
    private AgentRegistrar m_reg;

    UnsubscribeP28(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message msg = env.getMessage();
            WrappedDataInputStream din = new WrappedDataInputStream(msg);
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            ISubject subject = Subject.createFromStream(din);
            this.m_reg.unsubscribe(new UnsubscribeEvt(env, requestor, subject));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (EClientNotRegistered e) {
        }
        catch (EInvalidAdminAddress e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

