/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.BaseClientContextWrapper;
import progress.message.broker.ClientContextMgramQueue;
import progress.message.broker.EAsyncOpNotSupported;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GuarAckDoneEvt;
import progress.message.broker.GuarAckXchgEvt;
import progress.message.broker.GuarQAckDoneEvt;
import progress.message.broker.GuarQAckXchgEvt;
import progress.message.broker.ICCGuarDoubtManager;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextWrapper;
import progress.message.broker.IReenqueuer;
import progress.message.broker.IWindowAckManager;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.ReplyAckEvt;
import progress.message.broker.XOnceRequestReplyTracker;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.ISizedEnumeration;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.util.LongHashTable;
import progress.message.zclient.xonce.IMsgTracker;
import progress.message.zclient.xonce.IXOnceHandle;
import progress.message.zclient.xonce.ReleasedIndoubtQMsgs;

public class XOnceClientContextWrapper
extends BaseClientContextWrapper
implements IXOnceHandle,
IWindowAckManager {
    protected Object m_tableSyncObj = new Object();
    protected LongHashTable m_rcvdGuarQMsgs = new LongHashTable();
    protected LongHashTable m_rcvdGuarMsgs = new LongHashTable();
    protected HashMap m_guarQAcksPending = new HashMap();
    protected HashMap m_guarAcksPending = new HashMap();
    protected volatile List m_guarDNRs = null;
    protected IndexedList m_inDoubtQMsgs = new IndexedList();
    protected LongHashTable m_rcvdGuarRequests = new LongHashTable();
    protected LongHashTable m_unconfirmedGuarReplies = new LongHashTable();
    protected HashMap m_guarRepliesPending = new HashMap();
    private LongHashTable m_txnStorageAcks = null;
    protected Vector m_logMsgsExpectedIds = new Vector();
    protected Vector m_msgsToReenqueue = new Vector();

    public XOnceClientContextWrapper(IClientContext delegate, IClientContextWrapper delegator) {
        super(delegate, delegator);
        this.debugName("XOnceClientContextWrapper for " + delegate);
    }

    @Override
    public final IXOnceHandle getXOnceHandle() {
        return this;
    }

    @Override
    public IWindowAckManager getWindowAckManager() {
        return this;
    }

    @Override
    public String toString() {
        return "XOnceClientContextWrapper for " + this.m_delegate;
    }

    @Override
    public boolean needsGuarAck() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcvdGuarQMsg(long backTracking, IMsgTracker tracker) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_rcvdGuarQMsgs.put(backTracking, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcvdGuarMsg(long backTracking, IMsgTracker tracker) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_rcvdGuarMsgs.put(backTracking, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getGuarMsgTrkNums() {
        ArrayList ret = new ArrayList();
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.populateData(this.m_rcvdGuarMsgs, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getGuarQMsgTrkNums() {
        ArrayList ret = new ArrayList();
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.populateData(this.m_rcvdGuarQMsgs, ret);
        }
        return ret;
    }

    private void populateData(LongHashTable m_rcvdGuarQMsgs, ArrayList ret) {
        ISizedEnumeration<Long> dnr = m_rcvdGuarQMsgs.keyList();
        while (dnr.hasMoreElements()) {
            Long trk = (Long)dnr.nextElement();
            ret.add(trk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getUnconfirmedGuarAcks() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Iterator iterator = this.m_guarAcksPending.values().iterator();
            return XOnceClientContextWrapper.cloneVectorElements(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getUnconfirmedGuarQAcks() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Iterator iterator = this.m_guarQAcksPending.values().iterator();
            return XOnceClientContextWrapper.cloneVectorElements(iterator);
        }
    }

    private static List cloneVectorElements(Iterator iterator) {
        Vector uga = new Vector();
        while (iterator.hasNext()) {
            uga.add(iterator.next());
        }
        return uga;
    }

    @Override
    public void sendAck(long backTracking, IMgram m, long redirectClient) {
        long ackTracking = 0L;
        boolean guar = false;
        if (m != null && m.isGuarenteed() && m.isJMSPersistent()) {
            guar = true;
            ackTracking = this.addGuarUGA(backTracking);
        }
        this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(backTracking, redirectClient, (short)0, guar, ackTracking, false, 0, this.m_delegator.getChannel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendErrorAck(IMgram m, short errorCode, boolean queueAck) {
        if (m.isGuarenteed()) {
            if (queueAck) {
                Object object = this.m_tableSyncObj;
                synchronized (object) {
                    this.m_rcvdGuarQMsgs.remove(m.getGuarenteedTrackingNum());
                }
            }
            Object object = this.m_tableSyncObj;
            synchronized (object) {
                this.m_rcvdGuarMsgs.remove(m.getGuarenteedTrackingNum());
            }
        }
        this.m_delegate.sendErrorAck(m, errorCode, queueAck);
    }

    @Override
    public void receivedTxnMsg(int tid, long receiptTracking) {
        if (this.DEBUG) {
            this.debug("Received txn msg, tid = " + tid + ", receipt tracking: " + receiptTracking);
        }
        this.rcvdGuarMsg(receiptTracking, null);
    }

    @Override
    public void sendWindowAck(int tid, long receiptTracking, long[] storageTrackings) {
        if (this.m_txnStorageAcks == null) {
            this.m_txnStorageAcks = new LongHashTable();
        }
        if (storageTrackings == null || storageTrackings.length == 0) {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildWindowAck(receiptTracking, -1L, (short)0, false, -1L, true, tid, this.m_delegator.getChannel()));
            return;
        }
        Long[] ackTrackings = new Long[storageTrackings.length];
        long storageAckTracking = storageTrackings[storageTrackings.length - 1];
        this.m_txnStorageAcks.put(storageAckTracking, ackTrackings);
        long ackTracking = -1L;
        for (int i = 0; i < storageTrackings.length; ++i) {
            ackTracking = this.addGuarUGA(storageTrackings[i]);
            ackTrackings[i] = new Long(ackTracking);
        }
        this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildWindowAck(receiptTracking, storageAckTracking, (short)0, true, ackTracking, true, tid, this.m_delegator.getChannel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedWindowAckAck(int tid, long receiptTracking, long storageTracking) {
        Long[] ackTrackings;
        if (this.DEBUG) {
            this.debug("Received window ack ack, tid = " + tid + ", receipt tracking: " + receiptTracking + ", storage tracking: " + storageTracking);
        }
        if ((ackTrackings = (Long[])this.m_txnStorageAcks.remove(storageTracking)) != null) {
            Object object = this.m_tableSyncObj;
            synchronized (object) {
                for (int i = 0; i < ackTrackings.length; ++i) {
                    Long backTracking = (Long)this.m_guarAcksPending.remove(ackTrackings[i]);
                    if (backTracking == null) continue;
                    this.m_rcvdGuarMsgs.remove(backTracking);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addGuarUGA(long backTracking) {
        long ackTracking = s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_guarAcksPending.put(new Long(ackTracking), new Long(backTracking));
        }
        return ackTracking;
    }

    @Override
    public void sendQAck(long backTracking, IMgram m) {
        long ackTracking = 0L;
        boolean guar = false;
        if (m.isJMSPersistent()) {
            guar = true;
            ackTracking = this.addQueueUGA(backTracking);
        }
        this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildQAck(backTracking, -1L, (short)0, guar, ackTracking, false, 0, this.m_delegator.getChannel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addQueueUGA(long backTracking) {
        long ackTracking = s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_guarQAcksPending.put(new Long(ackTracking), new Long(backTracking));
        }
        return ackTracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleGuarQAckAck(long ackTracking) {
        boolean needEvent = false;
        long forwardTracking = 0L;
        IMsgTracker tracker = null;
        boolean replicateOnly = false;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Long backTracking = (Long)this.m_guarQAcksPending.remove(new Long(ackTracking));
            if (backTracking != null) {
                tracker = (IMsgTracker)this.m_rcvdGuarQMsgs.remove(backTracking);
                try {
                    needEvent = tracker.guarAckDone();
                    forwardTracking = tracker.getTracking();
                    replicateOnly = tracker.isReplicateOnly();
                }
                catch (NullPointerException npe) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)npe, 2);
                }
            } else {
                return false;
            }
        }
        if (needEvent) {
            GuarQAckDoneEvt evt = new GuarQAckDoneEvt(forwardTracking);
            evt.setReplicateOnly(replicateOnly);
            s_reg.getLogManager().addEvent(evt, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleGuarAckAck(long ackTracking) {
        boolean needEvent = false;
        long forwardTracking = 0L;
        IMsgTracker tracker = null;
        boolean replicateOnly = false;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Long backTracking = (Long)this.m_guarAcksPending.remove(new Long(ackTracking));
            if (backTracking != null) {
                tracker = (IMsgTracker)this.m_rcvdGuarMsgs.remove(backTracking);
                if (tracker != null) {
                    needEvent = tracker.guarAckDone();
                    replicateOnly = tracker.isReplicateOnly();
                    forwardTracking = tracker.getTracking();
                }
            } else {
                return false;
            }
        }
        if (needEvent) {
            GuarAckDoneEvt evt = new GuarAckDoneEvt(forwardTracking);
            evt.setReplicateOnly(replicateOnly);
            s_reg.getLogManager().addEvent(evt, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guarQAcksDone(List confirmed) {
        if (confirmed.isEmpty()) {
            return;
        }
        GuarQAckXchgEvt queueXchgEvt = new GuarQAckXchgEvt();
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            for (int i = 0; i < confirmed.size(); ++i) {
                Long backTracking = (Long)confirmed.get(i);
                IMsgTracker msgTracker = (IMsgTracker)this.m_rcvdGuarQMsgs.remove(backTracking);
                if (msgTracker != null) {
                    long fwdTracking = msgTracker.getTracking();
                    msgTracker.guarAckDone();
                    queueXchgEvt.addTracking(fwdTracking);
                }
                this.m_guarQAcksPending.values().remove(backTracking);
            }
        }
        s_reg.getLogManager().addEvent(queueXchgEvt, false);
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Acks confirmed for " + confirmed.size() + " ptp messages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guarAcksDone(List confirmed) {
        if (confirmed.isEmpty()) {
            return;
        }
        GuarAckXchgEvt pubsubXchgEvt = new GuarAckXchgEvt();
        GuarAckXchgEvt replOnlyPubsubXchgEvt = new GuarAckXchgEvt();
        int count = 0;
        int replOnlyCount = 0;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            for (int i = 0; i < confirmed.size(); ++i) {
                Long backTracking = (Long)confirmed.get(i);
                IMsgTracker msgTracker = (IMsgTracker)this.m_rcvdGuarMsgs.remove(backTracking);
                if (msgTracker != null) {
                    long fwdTracking = msgTracker.getTracking();
                    msgTracker.guarAckDone();
                    if (msgTracker.isReplicateOnly()) {
                        ++replOnlyCount;
                        replOnlyPubsubXchgEvt.addTracking(fwdTracking);
                    } else {
                        ++count;
                        pubsubXchgEvt.addTracking(fwdTracking);
                    }
                }
                this.m_guarAcksPending.values().remove(confirmed.get(i));
            }
        }
        if (count > 0) {
            pubsubXchgEvt.setReplicateOnly(false);
            s_reg.getLogManager().addEvent(pubsubXchgEvt, false);
        }
        if (replOnlyCount > 0) {
            replOnlyPubsubXchgEvt.setReplicateOnly(true);
            s_reg.getLogManager().addEvent(replOnlyPubsubXchgEvt, false);
        }
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Acks confirmed for " + (count + replOnlyCount) + " pubsub messages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRequestsPendingReply(List pendingInClient) {
        long id = this.m_delegator.getId();
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration<Long> pending = ((LongHashTable)this.m_rcvdGuarRequests.clone()).keys();
            while (pending.hasMoreElements()) {
                Long requestId = pending.nextElement();
                if (pendingInClient.contains(requestId)) continue;
                this.m_rcvdGuarRequests.remove(requestId);
                Object replyAckTracking = this.m_unconfirmedGuarReplies.remove(requestId);
                if (replyAckTracking != null) {
                    this.m_guarRepliesPending.remove(replyAckTracking);
                }
                s_reg.getTransactionMgr().processReplyAck(id, requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcvdXORequest(long reqId, IMgram mgram) {
        XOnceRequestReplyTracker xoTracker = new XOnceRequestReplyTracker(this.getId(), reqId, mgram);
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_rcvdGuarRequests.clear();
            this.m_unconfirmedGuarReplies.clear();
            this.m_guarRepliesPending.clear();
            this.m_rcvdGuarRequests.put(reqId, xoTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareXOReply(long reqId, IMgram m) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            XOnceRequestReplyTracker xoTracker = (XOnceRequestReplyTracker)this.m_rcvdGuarRequests.get(reqId);
            if (xoTracker != null) {
                xoTracker.notifyReply(m);
                long ackTracking = s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
                m.setGuarenteed(ackTracking);
                Long ackTrackingObj = new Long(ackTracking);
                this.m_unconfirmedGuarReplies.put(reqId, ackTrackingObj);
                this.m_guarRepliesPending.put(ackTrackingObj, new Long(reqId));
            }
        }
    }

    @Override
    public void sendReply(int reqId, IMgram m) {
        long lReqId = (long)reqId & 0xFFFFFFFFL;
        this.m_delegator.prepareXOReply(lReqId, m);
        this.m_delegator.sendThrough(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleXOReplyAck(long replyAckTracking) {
        Long replyAckTrackingObject = new Long(replyAckTracking);
        Long reqId = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            reqId = (Long)this.m_guarRepliesPending.remove(replyAckTrackingObject);
            if (reqId == null) {
                return false;
            }
            XOnceRequestReplyTracker xoTracker = (XOnceRequestReplyTracker)this.m_rcvdGuarRequests.get(reqId);
            if (xoTracker != null) {
                xoTracker.notifyConfirmed();
                this.m_rcvdGuarRequests.remove(reqId);
                this.m_unconfirmedGuarReplies.remove(reqId);
            }
        }
        long id = this.m_delegator.getId();
        s_reg.getTransactionMgr().processReplyAck(id, reqId);
        ReplyAckEvt evt = new ReplyAckEvt(id, reqId);
        s_reg.getLogManager().addEvent(evt, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPendingReplies() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration<Long> keys = this.m_rcvdGuarRequests.keys();
            Vector<Long> prep = new Vector<Long>();
            while (keys.hasMoreElements()) {
                prep.add(keys.nextElement());
            }
            return prep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allInDoubtMsgsAcked(List leavePendingQ, List leavePendingGuar, List leavePendingRsp) {
        if (this.DEBUG) {
            this.debug("IDR Complete, allInDoubtMsgsAcked() invoked.");
        }
        boolean reenqueued = false;
        Enumeration inDoubtQMsgs = null;
        ArrayList<IMgram> msgsToReenqueue = new ArrayList<IMgram>();
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            inDoubtQMsgs = this.m_inDoubtQMsgs.elements();
            this.m_inDoubtQMsgs = new IndexedList();
        }
        if (this.DEBUG) {
            this.debug("processing queue messages, messages shold be left pending are:");
            Iterator iter = leavePendingQ.iterator();
            while (iter.hasNext()) {
                this.debug("DNR msg " + (Long)iter.next());
            }
        }
        ClientContextMgramQueue outqueue = this.m_delegator.getOutQueue();
        while (inDoubtQMsgs.hasMoreElements()) {
            InDoubtQMsgContainer inDoubtMsg = (InDoubtQMsgContainer)inDoubtQMsgs.nextElement();
            if (leavePendingQ.contains(inDoubtMsg.getTracking())) {
                if (this.DEBUG) {
                    this.debug("leaving Q msg " + inDoubtMsg.getTracking() + " in doubt.");
                }
                this.addInDoubtQMsgInternal(inDoubtMsg);
                continue;
            }
            if (this.DEBUG) {
                this.debug("re-enqueueing Q msg " + inDoubtMsg.getTracking());
            }
            IMgram m = inDoubtMsg.getMsg(outqueue);
            msgsToReenqueue.add(m);
        }
        GroupSubscriptionClientContext gscc = this.m_delegator.getGroupSubscriptionCC();
        Object object2 = this.m_delegator.getSyncObj();
        synchronized (object2) {
            this.m_guarDNRs = leavePendingGuar;
            ICCGuarDoubtManager dm = this.m_delegator.getGuarDoubtManager();
            dm.setDoubtList(this.m_guarDNRs);
            Iterator setPending = this.m_guarDNRs.iterator();
            while (setPending.hasNext()) {
                long tracking = (Long)setPending.next();
                IMgram m = this.m_delegator.getOutQueue().removePendingReconnectGuar(tracking);
                if (m != null) {
                    try {
                        if (this.DEBUG) {
                            this.debug(" Setting DNR: " + m.getGuarenteedTrackingNum() + " pending, succ=" + m.isSuccessor());
                        }
                        this.m_delegator.getOutQueue().setGuarMsgPending(m);
                    }
                    catch (EDuplicateKey eDuplicateKey) {}
                    continue;
                }
                if (gscc == null) continue;
                this.m_delegator.getOutQueue().addGroupSubGuarPending(tracking, gscc);
            }
        }
        if (gscc != null) {
            if (this.DEBUG) {
                this.debug("Doubt resolved for group member " + this.m_delegator.getAppid() + " DNRs: " + this.m_guarDNRs);
            }
            gscc.onMemberDoubtResolved(this.m_delegator, leavePendingGuar);
        }
        if (!msgsToReenqueue.isEmpty()) {
            this.restoreQueueMessages(msgsToReenqueue);
        }
        this.m_delegate.allInDoubtMsgsAcked(leavePendingQ, leavePendingGuar, leavePendingRsp);
        this.resendUnconfirmedGuarReplies();
    }

    private void resendUnconfirmedGuarReplies() {
        Enumeration e = this.m_rcvdGuarRequests.elements();
        while (e.hasMoreElements()) {
            XOnceRequestReplyTracker tracker = (XOnceRequestReplyTracker)e.nextElement();
            IMgram m = tracker.getReply();
            if (m == null) continue;
            this.sendThrough(m);
        }
    }

    @Override
    public List getPendingRequests() {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreInDoubtQMsgs() {
        if (this.DEBUG) {
            this.debug("restoreInDoubtQMsgs() invoked");
        }
        Enumeration inDoubtQMsgs = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            inDoubtQMsgs = this.m_inDoubtQMsgs.elements();
            this.m_inDoubtQMsgs = new IndexedList();
        }
        ClientContextMgramQueue outqueue = this.m_delegator.getOutQueue();
        ArrayList<IMgram> msgsToReenqueue = new ArrayList<IMgram>();
        while (inDoubtQMsgs.hasMoreElements()) {
            InDoubtQMsgContainer inDoubtQMsg = (InDoubtQMsgContainer)inDoubtQMsgs.nextElement();
            IMgram m = inDoubtQMsg.getMsg(outqueue);
            m.setSuccessor(true);
            msgsToReenqueue.add(m);
        }
        this.restoreQueueMessages(msgsToReenqueue);
    }

    private void restoreQueueMessages(ArrayList msgsToReenqueue) {
        try {
            s_reg.getQMsgStateMgr().restoreXOnceMsgsToQueues(msgsToReenqueue, true, this.getReenqueuer());
        }
        catch (EAsyncOpNotSupported eaons) {
            BrokerComponent.getComponentContext().logMessage((Throwable)eaons, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleasedIndoubtQMsgs releaseInDoubtQMsgs() {
        if (this.DEBUG) {
            this.debug("releaseInDoubtQMsgs() invoked.");
        }
        ReleasedIndoubtQMsgs result = new ReleasedIndoubtQMsgs();
        AgentQueueProcessor qproc = s_reg.getQueueProc();
        Enumeration inDoubtQMsgs = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (this.m_inDoubtQMsgs.count() == 0) {
                return null;
            }
            inDoubtQMsgs = this.m_inDoubtQMsgs.elementsInReverse();
            this.m_inDoubtQMsgs = new IndexedList();
        }
        ClientContextMgramQueue outqueue = this.m_delegator.getOutQueue();
        ArrayList msgsToReenqueue = new ArrayList();
        InDoubtQMsgReenqueueEvt evt = null;
        while (inDoubtQMsgs.hasMoreElements()) {
            InDoubtQMsgContainer inDoubtQMsg = (InDoubtQMsgContainer)inDoubtQMsgs.nextElement();
            IMgram m = inDoubtQMsg.getMsg(outqueue);
            if (this.DEBUG) {
                this.debug("Releasing in doubt message marked redelivered: tracking=" + inDoubtQMsg);
            }
            m.setSuccessor(true);
            long tracking = m.getGuarenteedTrackingNum();
            if (qproc.getAgentQueue(m.getBrokerHandle().getLocalQueueName()) != null) {
                AgentQueueMsgTracker tracker;
                outqueue.restoreQMsgToPending(m);
                if (!m.isJMSPersistent()) continue;
                if (evt == null) {
                    evt = new InDoubtQMsgReenqueueEvt();
                    evt.setReplOnlyEvt(new InDoubtQMsgReenqueueEvt());
                    ((LogEvent)evt.getReplOnlyEvt()).setReplicateOnly(true);
                }
                if ((tracker = AgentQueueMsgTracker.getTracker(tracking)) != null) {
                    tracker.setReceiverId(0L);
                }
                if (m.isNonPersistentReplicated()) {
                    ((InDoubtQMsgReenqueueEvt)evt.getReplOnlyEvt()).addTracking(tracking);
                    continue;
                }
                evt.addTracking(tracking);
                continue;
            }
            result.addCancelledID(tracking);
        }
        result.setReenqueueEvt(evt);
        return result;
    }

    private final IReenqueuer getReenqueuer() {
        AgentConnection c = this.m_delegator.getConnection();
        return c != null ? c.getAgentSender() : null;
    }

    @Override
    public boolean postponeDisconnect() {
        if (this.m_delegate.postponeDisconnect()) {
            if (!this.m_delegator.isGroupSubscriptionMember()) {
                this.m_guarDNRs = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void disconnect(boolean sync) {
        this.m_delegate.disconnect(sync);
        this.guarAcksDone(this.getGuarMsgTrkNums());
        this.guarQAcksDone(this.getGuarQMsgTrkNums());
        List oldDnrs = this.m_guarDNRs;
        this.m_guarDNRs = null;
        GroupSubscriptionClientContext gscc = this.m_delegator.getGroupSubscriptionCC();
        if (gscc != null) {
            gscc.onMemberDisconnect(this.m_delegator, oldDnrs);
        }
    }

    @Override
    public void addInDoubtQMsg(long tracking) {
        this.addInDoubtQMsgInternal(new InDoubtQMsgContainer(tracking));
    }

    @Override
    public void addInDoubtQMsg(IMgram msg) {
        this.addInDoubtQMsgInternal(new InDoubtQMsgContainer(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addInDoubtQMsgInternal(InDoubtQMsgContainer idmc) {
        s_reg.getQMsgStateMgr().addInDoubtMsg(idmc.getTracking());
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_inDoubtQMsgs.appendNoDup(idmc.getTracking(), idmc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram removeInDoubtQMsg(long tracking) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            ListNode node = this.m_inDoubtQMsgs.remove(tracking);
            if (node != null) {
                if (this.DEBUG) {
                    this.debug("in-doubt q msg " + tracking + " removed");
                }
                return ((InDoubtQMsgContainer)node.obj).m_msg;
            }
            if (this.DEBUG) {
                this.debug("failed to remove in-doubt q msg " + tracking);
            }
        }
        return null;
    }

    @Override
    public void inDoubtQMsgAcked(long tracking) {
        throw new UnsupportedOperationException("UGA resolution not supported.");
    }

    @Override
    public void inDoubtMsgAcked(long tracking) {
        throw new UnsupportedOperationException("UGA resolution not supported.");
    }

    @Override
    public boolean isXOnce() {
        return true;
    }

    @Override
    public boolean isDNR(IMgram msg) {
        List refGuarDNRs = this.m_guarDNRs;
        if (refGuarDNRs == null || !msg.isGuarenteed()) {
            return false;
        }
        return refGuarDNRs.contains(new Long(msg.getGuarenteedTrackingNum()));
    }

    private class InDoubtQMsgContainer {
        private Long m_tracking;
        private IMgram m_msg;

        public InDoubtQMsgContainer(IMgram msg) {
            this.m_msg = msg;
            this.m_tracking = new Long(msg.getGuarenteedTrackingNum());
        }

        public InDoubtQMsgContainer(long tracking) {
            this.m_tracking = new Long(tracking);
        }

        public final IMgram getMsg(ClientContextMgramQueue outqueue) {
            if (this.m_msg == null) {
                return this.findMsg(outqueue);
            }
            return this.m_msg;
        }

        public final Long getTracking() {
            return this.m_tracking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final IMgram findMsg(ClientContextMgramQueue outqueue) {
            AgentQueueMsgTracker tracker;
            IMgram m = null;
            Object object = XOnceClientContextWrapper.this.m_delegator.getSyncObj();
            synchronized (object) {
                m = outqueue.removePendingQmsg(this.m_tracking);
                new EAssertFailure(this + " Indoubt message found on pending queue.");
            }
            if (m == null && (tracker = AgentQueueMsgTracker.getTracker(this.m_tracking)) != null) {
                m = tracker.getMessage();
            }
            if (m == null) {
                m = BaseClientContextWrapper.s_reg.getQueueMsgSaver().retrieveMgram(this.m_tracking);
            }
            if (m == null) {
                EAssertFailure t = new EAssertFailure(this + " In doubt message not found for reenqueuing: " + this.m_tracking);
                BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
            }
            return m;
        }

        public String toString() {
            return "In doubt message trk= " + this.m_tracking;
        }
    }
}

