/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSInfoOp;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class CWADSListXferOp
extends DebugObject
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private byte m_phase;
    private Vector m_infoMgrams = new Vector();
    private static final byte CURRENT_VERSION = 0;
    private static int m_errorCode = -1;

    CWADSListXferOp(IDurableReplyQueue replyQueue, byte phase, Iterator durSubs) {
        super(DebugState.GLOBAL_DEBUG_ON ? "CWADSListXferOp" : null);
        this.m_replyQueue = replyQueue;
        this.m_phase = phase;
        try {
            while (durSubs.hasNext()) {
                IClientContext cc = (IClientContext)durSubs.next();
                CWADSInfoOp info = new CWADSInfoOp(cc);
                if (this.DEBUG) {
                    this.debug("CWADSListXferOp ctor #1 adding info for " + info.toString());
                }
                this.m_infoMgrams.add(info.makeMgram());
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    public CWADSListXferOp(IDurableReplyQueue replyQueue, IMgram mg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "CWADSListXferOp" : null);
        this.m_replyQueue = replyQueue;
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 17) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_phase = dinput.readByte();
            LinkedList ll = iopHandle.getMgramList();
            if (ll != null) {
                for (int count = 0; count < ll.size(); ++count) {
                    this.m_infoMgrams.add((IMgram)ll.get(count));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void doit(BrokerDatabase db_not_used_here) throws IOException {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        this.m_replyQueue.enqueue(reg.getCWADSMsgHandler().handleCWADSListXferOp(this));
    }

    public Enumeration getInfoMgrams() {
        return this.m_infoMgrams.elements();
    }

    public byte getPhase() {
        return this.m_phase;
    }

    @Override
    public void postProcess() {
    }

    public static IMgram makeMgram(byte phase, Iterator durSubs) {
        IMgram m = MgramFactory.getMgramFactory().buildOperationMgram(17);
        try {
            ObjectOutput doutput = m.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeByte(phase);
            while (durSubs.hasNext()) {
                IClientContext cc = (IClientContext)durSubs.next();
                try {
                    CWADSInfoOp info = new CWADSInfoOp(cc);
                    IMgram mgram = info.makeMgram();
                    m.getOperationHandle().addMgram(mgram);
                }
                catch (ESubscriptionNotFound eSubscriptionNotFound) {}
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return m;
    }

    public int getErrorCode() {
        return m_errorCode;
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

