/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSPingReplyOp;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.client.EUserAlreadyConnected;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.zclient.SessionConfig;

public class CWADSPingOp
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private long m_clientId;
    private long m_preemptingRootClientId = -1L;
    private static final byte CURRENT_VERSION = 0;
    private static int m_errorCode = -1;

    CWADSPingOp(IDurableReplyQueue replyQueue, long ccid, long preemptingRootClientId) {
        this.m_replyQueue = replyQueue;
        this.m_clientId = ccid;
        this.m_preemptingRootClientId = preemptingRootClientId;
    }

    public CWADSPingOp(IDurableReplyQueue replyQueue, IMgram mg) {
        this.m_replyQueue = replyQueue;
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 15) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_clientId = dinput.readLong();
            this.m_preemptingRootClientId = dinput.readLong();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doit(BrokerDatabase dbNotUseHere) throws IOException {
        Object result = null;
        IClientContext clientContext = null;
        try {
            clientContext = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
        }
        catch (EClientNotRegistered ecnr) {
            this.replyBackSubscriberNotFound();
            return;
        }
        clientContext.lock();
        boolean locked = true;
        try {
            locked = this.processClientContext(clientContext, locked);
            this.enqueueReply(clientContext);
        }
        finally {
            if (locked) {
                clientContext.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processClientContext(IClientContext clientContext, boolean lockedParam) {
        boolean locked = lockedParam;
        while (clientContext.isConnected()) {
            if (clientContext.isResumable()) {
                try {
                    IClientContext rootClientContext;
                    long rootId = clientContext.getRootId();
                    if (rootId != this.m_preemptingRootClientId && !AgentRegistrar.getAgentRegistrar().isInternalAppid(rootId) || (rootClientContext = AgentRegistrar.getAgentRegistrar().getClient(rootId)).getAppid().startsWith(SessionConfig.TMP_APPID_PREFIX)) break;
                    clientContext.unlock();
                    locked = false;
                    rootClientContext.lock();
                    boolean errorPreemptingRoot = CWADSPingOp.preemptRootClientContext(rootId, rootClientContext);
                    clientContext.lock();
                    locked = true;
                    if (errorPreemptingRoot) {
                        break;
                    }
                }
                catch (EClientNotRegistered ecnr) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ecnr, 2);
                }
            }
            if (!clientContext.isConnected() || clientContext.getCWADSActiveBroker() == null || clientContext.getCWADSActiveBroker().getId() != clientContext.getId()) break;
            try {
                locked = false;
                AgentRegistrar.getAgentRegistrar();
                AgentRegistrar.attemptToPreempt(clientContext, this.m_preemptingRootClientId);
            }
            catch (EUserAlreadyConnected ex) {
                break;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                clientContext.lock();
                locked = true;
            }
        }
        return locked;
    }

    private static boolean preemptRootClientContext(long rootId, IClientContext rootClientContext) {
        boolean errorPreemptingRoot = false;
        if (rootClientContext.isConnected()) {
            try {
                AgentRegistrar.getAgentRegistrar();
                AgentRegistrar.attemptToPreempt(rootClientContext, rootId);
            }
            catch (EUserAlreadyConnected ex1) {
                errorPreemptingRoot = true;
            }
            catch (InterruptedException ex1) {
                errorPreemptingRoot = true;
                Thread.currentThread().interrupt();
            }
        } else {
            rootClientContext.unlock();
        }
        return errorPreemptingRoot;
    }

    private void enqueueReply(IClientContext clientContext) {
        try {
            BrokerSubscription brokerSubscription = clientContext.getDurableBrokerSubscription();
            CWADSPingReplyOp result = new CWADSPingReplyOp(true, clientContext, brokerSubscription);
            this.m_replyQueue.enqueue(result);
        }
        catch (ESubscriptionNotFound esnf) {
            this.replyBackSubscriberNotFound();
        }
    }

    private void replyBackSubscriberNotFound() {
        CWADSPingReplyOp result = new CWADSPingReplyOp();
        result.setErrorCode(4);
        this.m_replyQueue.enqueue(result);
    }

    @Override
    public void postProcess() {
    }

    public static IMgram makeMgram(long ccid, long preemptingRootClientId) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(15);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeLong(ccid);
            doutput.writeLong(preemptingRootClientId);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        result.setPriority((byte)12);
        return result;
    }

    public int getErrorCode() {
        return m_errorCode;
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

