/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSInfo;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class CWADSPingReplyOp
extends CWADSInfo
implements IDurableReplyOperation {
    private static int m_errorCode = 0;
    private boolean m_replyready = false;
    private static final byte CURRENT_VERSION = 0;

    public CWADSPingReplyOp() {
    }

    public CWADSPingReplyOp(boolean replyready, IClientContext cc, BrokerSubscription bs) throws ESubscriptionNotFound {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        this.loadFromLocalInfo(cc, bs);
        this.m_replyready = replyready;
    }

    public CWADSPingReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 16) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            this.deserializeInfo(dinput);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isComplete() {
        return this.m_replyready;
    }

    public void doit(BrokerDatabase db_not_used_here) throws IOException {
    }

    public void postProcess() {
    }

    @Override
    public final IMgram getMgram() {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(16);
        try {
            this.serializeInfo(result.getPayloadOutputStreamHandle());
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        result.setPriority((byte)12);
        return result;
    }

    @Override
    public final void serializeInfo(DataOutput doutput) throws IOException {
        doutput.writeByte(0);
        if (m_errorCode == 0) {
            doutput.writeBoolean(false);
        } else {
            doutput.writeBoolean(true);
            doutput.writeShort(m_errorCode);
        }
        super.serializeInfo(doutput);
    }

    @Override
    public final void deserializeInfo(DataInput dinput) throws IOException {
        dinput.readByte();
        if (dinput.readBoolean()) {
            m_errorCode = dinput.readShort();
        }
        super.deserializeInfo(dinput);
    }

    @Override
    public int getErrorCode() {
        return m_errorCode;
    }

    public void setErrorCode(int error) {
        m_errorCode = error;
        this.m_replyready = true;
    }

    @Override
    public String toString() {
        return "CWADSPingReplyOp: " + super.toString() + " Errorcode = " + m_errorCode;
    }
}

