/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerJob;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.durable.DurableBrokerJobReplyQueue;
import progress.message.broker.durable.DurableCountSizeRestoreOp;
import progress.message.broker.durable.DurableCountSizeRestoreReplyOp;
import progress.message.zclient.DebugThread;

public class DurableCountSizeRestorer
extends DebugThread {
    private long m_maxMessageId;
    private int m_chunkSize;
    private long m_currentTrkNum = -1L;
    private Enumeration m_trackers;

    public DurableCountSizeRestorer(long maxMessageId, int chunkSize, Enumeration trackers) {
        super("DurableCountSizeRestorer");
        this.m_maxMessageId = maxMessageId;
        this.m_chunkSize = chunkSize;
        this.m_trackers = trackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        long startTime = 0L;
        try {
            while (this.m_trackers.hasMoreElements() && !Broker.exiting && !Thread.currentThread().isInterrupted()) {
                DurableCountSizeRestoreReplyOp reply = null;
                ICCSizeTracker tracker = (ICCSizeTracker)this.m_trackers.nextElement();
                this.m_currentTrkNum = AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().getMaxDeleteMsgId(tracker.getCC().getId());
                if (this.DEBUG) {
                    this.debug("DurableCountSizeRestorer: recalculation starting; cc= " + tracker.getCC().getAppid() + " startingTrackingNum= " + this.m_currentTrkNum);
                }
                if (this.DEBUG) {
                    startTime = System.currentTimeMillis();
                }
                int calls = 0;
                do {
                    block13: {
                        BrokerJob job = new BrokerJob(1);
                        try {
                            DurableCountSizeRestoreOp request = new DurableCountSizeRestoreOp(new DurableBrokerJobReplyQueue(job));
                            request.init(this.m_chunkSize, this.m_maxMessageId, tracker.getCC().getId(), this.m_currentTrkNum);
                            Collection result = AgentRegistrar.getAgentRegistrar().getDurableManager().performLocalDurableRequest(request, job);
                            ++calls;
                            Iterator iter = result.iterator();
                            if (iter.hasNext()) {
                                reply = (DurableCountSizeRestoreReplyOp)iter.next();
                            }
                            if (reply != null) break block13;
                            return;
                        }
                        catch (InterruptedException e) {
                            AgentRegistrar.getAgentRegistrar().getDurableManager().resetQueryThread();
                            return;
                        }
                    }
                    this.m_currentTrkNum = reply.getTrkNum();
                } while (!reply.isComplete() && !Broker.exiting && !Thread.currentThread().isInterrupted());
                if (!this.DEBUG) continue;
                this.debug("Restore Complete for: " + tracker.getCC().getAppid() + " Time: " + (System.currentTimeMillis() - startTime) + " numCalls= " + calls);
            }
        }
        finally {
            AgentRegistrar.getAgentRegistrar().getDurableManager().resetQueryThread();
        }
    }
}

