/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableGetMgramReplyOp
implements IDurableReplyOperation {
    private boolean m_wasMessageFound;
    private static final byte CURRENT_VERSION = 0;
    private boolean m_containsError = false;
    private int m_errorCode = 0;
    private IMgram m_result = null;

    public DurableGetMgramReplyOp(boolean wasFound, IMgram result) {
        this.m_wasMessageFound = wasFound;
        this.m_result = result;
    }

    public DurableGetMgramReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 7) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        ObjectInput dinput = mg.getPayloadInputStreamHandle();
        try {
            dinput.readByte();
            this.m_wasMessageFound = dinput.readBoolean();
            this.m_containsError = dinput.readBoolean();
            if (this.m_containsError) {
                this.m_errorCode = dinput.readInt();
            }
            if (this.m_wasMessageFound) {
                this.m_result = (IMgram)iopHandle.getMgramList().getFirst();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IMgram getResult() {
        return this.m_result;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    @Override
    public boolean isComplete() {
        return this.m_wasMessageFound;
    }

    public void setErrorCode(int errorCode) {
        this.m_errorCode = errorCode;
        this.m_containsError = true;
    }

    public boolean wasMessageFound() {
        return this.m_wasMessageFound;
    }

    @Override
    public IMgram getMgram() {
        IMgram mg = MgramFactory.getMgramFactory().buildOperationMgram(7);
        ObjectOutput doutput = mg.getPayloadOutputStreamHandle();
        IOperationHandle iopHandle = mg.getOperationHandle();
        try {
            doutput.writeByte(0);
            doutput.writeBoolean(this.m_wasMessageFound);
            doutput.writeBoolean(this.m_containsError);
            if (this.m_containsError) {
                doutput.writeInt(this.m_errorCode);
            }
            if (this.m_wasMessageFound) {
                iopHandle.addMgram(this.m_result);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return mg;
    }
}

