/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableRemoveReplyOp
implements IDurableReplyOperation {
    private boolean m_wasMessageFound;
    private boolean m_containsError;
    private int m_errorCode;
    private static final int CURRENT_VERSION = 0;

    public DurableRemoveReplyOp(boolean wasFound) {
        this.m_wasMessageFound = wasFound;
    }

    public DurableRemoveReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 11) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        ObjectInput dinput = mg.getPayloadInputStreamHandle();
        try {
            dinput.readByte();
            this.m_wasMessageFound = dinput.readBoolean();
            this.m_containsError = dinput.readBoolean();
            if (this.m_containsError) {
                this.m_errorCode = dinput.readInt();
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    @Override
    public IMgram getMgram() {
        IMgram mg = MgramFactory.getMgramFactory().buildOperationMgram(11);
        try {
            ObjectOutput doutput = mg.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeBoolean(this.m_wasMessageFound);
            doutput.writeBoolean(this.m_containsError);
            if (this.m_containsError) {
                doutput.writeInt(this.m_errorCode);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return mg;
    }

    @Override
    public boolean isComplete() {
        return this.m_wasMessageFound;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    public boolean wasMessageFound() {
        return this.m_wasMessageFound;
    }

    public void setErrorCode(int errorCode) {
        this.m_errorCode = errorCode;
        this.m_containsError = true;
    }
}

