/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import progress.message.broker.Config;
import progress.message.broker.gs.GSManager;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IExpirePrecheck;

public class GSOrphanedMessageChecker
extends DebugObject
implements IExpirePrecheck {
    private GSManager m_man = null;

    public GSOrphanedMessageChecker(GSManager man) {
        this.m_man = man;
    }

    @Override
    public int precheck(IMgram m) {
        if (this.isGSAOrphan(m)) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isPrecheckCandidate(IMgram m) {
        return this.isGSAMessage(m) && m.forRemoteNode(Config.ROUTING_NODE_NAME);
    }

    public boolean isGSAOrphan(IMgram m) {
        if (!this.isGSAMessage(m)) {
            return false;
        }
        String node = m.getRouting();
        return m.forRemoteNode(Config.ROUTING_NODE_NAME) && this.m_man.locateGSTracker(node) == null;
    }

    public boolean isGSAMessage(IMgram m) {
        if (!m.isPubSub()) {
            return false;
        }
        return m.getRoutingHandle().isGSAPublication();
    }
}

