/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Hashtable;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSNodeInfo;
import progress.message.broker.gs.GSRequest;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Session;

class GSPingHandler
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;
    private GSTransport m_transport;
    private GSManager m_manager;

    GSPingHandler(AgentRegistrar reg, GSManager manager, GSTransport transport) {
        super("GSPingHandler");
        this.m_reg = reg;
        this.m_manager = manager;
        this.m_transport = transport;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        if (!BrokerStateManager.getBrokerStateManager().isActive()) {
            return;
        }
        try {
            IMgram mgram = env.getMgram();
            ObjectInput in = mgram.getPayloadInputStreamHandle();
            in.readByte();
            String remoteNode = in.readUTF();
            String remoteBroker = in.readUTF();
            GSNodeInfo ni = this.m_manager.getNodeInfo(remoteNode);
            Hashtable requestList = null;
            if (ni != null) {
                requestList = ni.getRequestList();
            }
            if (this.DEBUG) {
                this.debug("Received: globalPingSubscriptions from remote node and broker " + remoteNode + "," + remoteBroker);
            }
            try {
                while (true) {
                    String homeNode = in.readUTF();
                    String homeBroker = in.readUTF();
                    String topic = in.readUTF();
                    GSVirtualClock virtualClock = GSVirtualClock.unserialize(in);
                    if (this.DEBUG) {
                        this.debug("Received ping test for: home node=" + homeNode + ",home broker=" + homeBroker + ",topic=" + topic + ",vc=" + virtualClock);
                    }
                    if (!homeNode.equals(Config.ROUTING_NODE_NAME)) continue;
                    if (homeBroker.equals(Config.BROKER_NAME)) {
                        GSRequest req = null;
                        if (requestList != null) {
                            req = (GSRequest)requestList.get(topic);
                        }
                        if (req == null) {
                            this.debug("Status:stale(no longer proxied)! removing");
                            req = new GSRequest(Config.ROUTING_NODE_NAME, Config.BROKER_NAME, remoteNode, topic, null, 2, GSVirtualClock.assignVirtualClock());
                            this.m_manager.getRequestSender().sendRequest(req);
                            continue;
                        }
                        if (req.getVirtualClock() == null || req.getVirtualClock().compareTo(virtualClock) > 0) {
                            if (this.DEBUG) {
                                this.debug("Status:stale(not current)! resending with latest vc=" + req.getVirtualClock());
                            }
                            this.m_manager.getRequestSender().sendRequest(req);
                            continue;
                        }
                        if (!this.DEBUG) continue;
                        this.debug("Status:current!");
                        continue;
                    }
                    long cid = AddrUtil.stringToClientId(homeBroker, "Broker");
                    if (!InterbrokerHook.isSet() || InterbrokerHook.isNeighbor(cid)) continue;
                    this.debug("Status:stale(broker not known in the cluster)! removing");
                    GSRequest req = new GSRequest(Config.ROUTING_NODE_NAME, homeBroker, remoteNode, topic, null, 2, GSVirtualClock.maximum());
                    this.m_manager.getRequestSender().sendRequest(req);
                }
            }
            catch (EOFException e) {
            }
        }
        catch (IOException ioe) {
            System.err.println("Corrupt globalPingSubscriptions message:" + ioe);
        }
    }
}

