/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.IClientContext;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSNodeInfo;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Session;

class GSReconciliationHandler
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;
    private GSTransport m_transport;
    private GSManager m_manager;
    private Hashtable<Long, SubscriptionsTable> m_markersTable;
    private Hashtable<Long, Integer> m_lastSeqNrTable;
    private Hashtable<Long, GSVirtualClock> m_lastVCTable;

    GSReconciliationHandler(AgentRegistrar reg, GSManager manager, GSTransport transport) {
        super("GSReconciliationHandler");
        this.m_reg = reg;
        this.m_manager = manager;
        this.m_transport = transport;
        this.m_markersTable = new Hashtable();
        this.m_lastSeqNrTable = new Hashtable();
        this.m_lastVCTable = new Hashtable();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Session s, Envelope env) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructDeleteMarks(String rn, String rb) throws EClientNotRegistered {
        long id = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(rn, rb);
        Long ID = id;
        IClientContext cc = this.m_reg.getClient(id);
        if (cc != null) {
            SubscriptionsTable subs = cc.getSubscriptions();
            SubscriptionsTable shallowClone = null;
            SubscriptionsTable subscriptionsTable = subs;
            synchronized (subscriptionsTable) {
                shallowClone = (SubscriptionsTable)subs.clone();
            }
            this.m_markersTable.put(ID, shallowClone);
        }
    }

    private void removeDeleteMark(GSSubscribeEvt evt) throws EClientNotRegistered {
        long id = evt.getClientId();
        Long ID = id;
        ISubject subject = evt.getSubject();
        SubscriptionsTable markers = this.m_markersTable.get(ID);
        if (markers != null) {
            markers.remove(subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeleteMarks(String rn, String rb, GSVirtualClock masterReconcileClock) throws EClientNotRegistered, InterruptedException {
        long id = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(rn, rb);
        Long ID = id;
        SubscriptionsTable markers = this.m_markersTable.get(ID);
        if (markers != null) {
            try {
                Enumeration entries = markers.elements();
                while (entries.hasMoreElements()) {
                    BrokerSubscription bs = (BrokerSubscription)entries.nextElement();
                    try {
                        if (this.DEBUG) {
                            this.debug("Deleting marked GS" + bs.getSubject() + ", " + rn);
                        }
                        this.m_reg.unsubscribe(new UnsubscribeEvt(null, id, bs.getSubject(), masterReconcileClock));
                    }
                    catch (EOldVirtualClockException eovc) {
                        if (!this.DEBUG) continue;
                        this.debug("delete rejected stale vc:" + eovc);
                    }
                }
            }
            finally {
                this.m_markersTable.remove(ID);
            }
        }
    }

    private synchronized void checkChainIntegrity(String rn, String rb, GSVirtualClock VC, int seqnr) throws IOException {
        long id = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(rn, rb);
        Long ID = id;
        int lastSeqnr = -1;
        Integer lastSN = this.m_lastSeqNrTable.get(ID);
        if (lastSN != null) {
            lastSeqnr = lastSN;
        }
        GSVirtualClock lastVC = this.m_lastVCTable.get(ID);
        if (seqnr != lastSeqnr + 1 || lastVC != null && lastVC.compareTo(VC) != 0) {
            this.m_lastSeqNrTable.remove(ID);
            this.m_lastVCTable.remove(ID);
            throw new IOException("Abandoning reconciliation: bad integrity. seqnr=" + seqnr + "(last=" + lastSeqnr + "), VC=" + VC + "(last=" + lastVC + ").");
        }
        Integer SN = seqnr;
        this.m_lastSeqNrTable.put(ID, SN);
        this.m_lastVCTable.put(ID, VC);
    }

    private synchronized void resetChainIntegrity(String rn, String rb) {
        long id = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(rn, rb);
        Long ID = id;
        this.m_lastSeqNrTable.remove(ID);
        this.m_lastVCTable.remove(ID);
    }

    public void onReconcileAdminRequest(Envelope request, String routeNodeName) {
        if (this.DEBUG) {
            this.debug("onReconcileAdminRequest: " + routeNodeName);
        }
        GSNodeInfo ni = this.m_manager.getNodeInfo(routeNodeName);
        this.m_transport.sendReconciliationList(routeNodeName, ni, true);
    }
}

