/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.gs.IGSRemoteRequest;
import progress.message.msg.IMgram;
import progress.message.util.IndexedList;

public class GSReconciliationMgramWrapper
implements IGSRemoteRequest {
    private String m_remoteNodeName = null;
    private IMgram m_mgram;
    private int m_seqnr = 0;
    private boolean m_initiateReverseReconcile = false;

    public GSReconciliationMgramWrapper(IMgram mgram, String remoteNodeName, int seqnr, boolean initiateReverseReconcile) {
        this.m_mgram = mgram;
        this.m_remoteNodeName = remoteNodeName;
        this.m_seqnr = seqnr;
        this.m_initiateReverseReconcile = initiateReverseReconcile;
    }

    @Override
    public String getRemoteNodeName() {
        return this.m_remoteNodeName;
    }

    @Override
    public String getUniqueKey() {
        return "$ISYS.GSA.globalReconcile:" + this.m_seqnr;
    }

    @Override
    public IMgram createMgram() throws IOException {
        return this.m_mgram;
    }

    @Override
    public String opStr() {
        return "reconcile";
    }

    @Override
    public boolean preNodeQueueInsertionInterceptor(IndexedList list) {
        if (this.m_seqnr == 0) {
            if (this.m_initiateReverseReconcile) {
                list.clearList();
            } else {
                IGSRemoteRequest req;
                Enumeration<Object> entries = list.elements();
                Vector<IGSRemoteRequest> deletes = new Vector<IGSRemoteRequest>();
                while (entries.hasMoreElements()) {
                    req = (IGSRemoteRequest)entries.nextElement();
                    if (req.getUniqueKey().startsWith("$ISYS.GSA.globalPingSubscriptions") || req.getUniqueKey().startsWith("$ISYS.GSA.globalReconcile")) continue;
                    deletes.add(req);
                }
                entries = deletes.elements();
                while (entries.hasMoreElements()) {
                    req = (IGSRemoteRequest)entries.nextElement();
                    list.remove(req.getUniqueKey());
                }
            }
        }
        return true;
    }
}

