/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.gs.IGSRemoteRequest;
import progress.message.msg.IMgram;
import progress.message.util.IndexedList;

public class GSRequest
implements IGSRemoteRequest {
    private static final byte CURRENT_VERSION = 0;
    private String m_homeNodeName;
    private String m_homeBrokerName;
    private String m_remoteNodeName;
    private String m_receivingBrokerName;
    private boolean m_suppressNotification;
    private String m_topic;
    private String[] m_selectors;
    private int m_opcode;
    private GSVirtualClock m_virtualClock;
    private GSTransport m_transport;

    GSRequest() {
    }

    public GSRequest(String homeNodeName, String homeBrokerName, String remoteNodeName, String topic, String[] selectors, int opcode, GSVirtualClock clock) {
        this.m_homeNodeName = homeNodeName;
        this.m_homeBrokerName = homeBrokerName;
        this.m_remoteNodeName = remoteNodeName;
        this.m_receivingBrokerName = "";
        this.m_suppressNotification = false;
        this.m_topic = topic;
        this.m_selectors = selectors;
        this.m_opcode = opcode;
        this.m_virtualClock = clock;
    }

    public void setHomeNodeName(String s) {
        this.m_homeNodeName = s;
    }

    public void setHomeBrokerName(String s) {
        this.m_homeBrokerName = s;
    }

    public void setRemoteNodeName(String s) {
        this.m_remoteNodeName = s;
    }

    public void setReceivingBrokerName(String s) {
        this.m_receivingBrokerName = s;
    }

    public void setSuppressNotification(boolean b) {
        this.m_suppressNotification = b;
    }

    public void setTopic(String s) {
        this.m_topic = s;
    }

    public void setOpCode(int i) {
        this.m_opcode = i;
    }

    public void setSelectors(String[] s) {
        this.m_selectors = s;
    }

    public void setVirtualClock(GSVirtualClock c) {
        this.m_virtualClock = c;
    }

    public String getHomeNodeName() {
        return this.m_homeNodeName;
    }

    public String getHomeBrokerName() {
        return this.m_homeBrokerName;
    }

    @Override
    public String getRemoteNodeName() {
        return this.m_remoteNodeName;
    }

    public String getReceivingBrokerName() {
        return this.m_receivingBrokerName;
    }

    public boolean getSuppressNotification() {
        return this.m_suppressNotification;
    }

    public String getTopic() {
        return this.m_topic;
    }

    public int getOpCode() {
        return this.m_opcode;
    }

    public String[] getSelectors() {
        return this.m_selectors;
    }

    public GSVirtualClock getVirtualClock() {
        return this.m_virtualClock;
    }

    public String toString() {
        String selectors = null;
        if (this.m_selectors != null) {
            selectors = "";
            for (int ii = 0; ii < this.m_selectors.length; ++ii) {
                selectors = selectors + (this.m_selectors[ii].length() > 0 ? this.m_selectors[ii] : "empty") + " ";
            }
        }
        return this.opStr() + ":homeNode=" + this.m_homeNodeName + ",homeBroker=" + this.m_homeBrokerName + ",topic=" + this.m_topic + ",sel = " + selectors + ",vc=" + this.getVirtualClockStr();
    }

    @Override
    public String opStr() {
        switch (this.m_opcode) {
            case 1: {
                return "subscribe";
            }
            case 2: {
                return "unsubscribe";
            }
            case 0: {
                return "update";
            }
        }
        return "???";
    }

    String getVirtualClockStr() {
        if (this.m_virtualClock == null) {
            return "UNASSIGNED";
        }
        return this.m_virtualClock.toString();
    }

    void dump() {
        System.out.println("[req #] " + this.getVirtualClockStr() + " [topic] " + this.m_remoteNodeName + "::" + this.m_topic);
        if (this.m_selectors != null) {
            for (int ii = 0; ii < this.m_selectors.length; ++ii) {
                if (this.m_selectors[ii].equals("")) continue;
                System.out.println("     [selector] " + this.m_selectors[ii]);
            }
        }
        if (this.m_opcode == 2) {
            System.out.println("     [operation] " + this.opStr());
        }
    }

    public void serialize(DataOutput out) throws IOException {
        this.serialize(out, true);
    }

    public void serialize(DataOutput out, boolean full) throws IOException {
        if (full) {
            out.writeByte(0);
            out.writeInt(this.getOpCode());
            out.writeUTF(this.getHomeNodeName());
            out.writeUTF(this.getHomeBrokerName());
            out.writeUTF(this.getReceivingBrokerName());
            out.writeBoolean(this.getSuppressNotification());
        }
        out.writeUTF(this.getTopic());
        String[] sel = this.getSelectors();
        if (sel != null) {
            out.writeInt(sel.length);
            for (int ii = 0; ii < sel.length; ++ii) {
                out.writeUTF(sel[ii]);
            }
        } else {
            out.writeInt(0);
        }
        if (this.m_virtualClock == null) {
            throw new IOException("Can't serialize null virtual clock");
        }
        this.m_virtualClock.serialize(out);
    }

    public static GSRequest deserialize(DataInput in) throws IOException {
        return GSRequest.deserialize(in, true);
    }

    public static GSRequest deserialize(DataInput in, boolean full) throws IOException {
        GSRequest req = new GSRequest();
        if (full) {
            in.readByte();
            req.m_opcode = in.readInt();
            req.m_homeNodeName = in.readUTF();
            req.m_homeBrokerName = in.readUTF();
            req.m_receivingBrokerName = in.readUTF();
            req.m_suppressNotification = in.readBoolean();
        }
        req.m_topic = in.readUTF();
        int numSelectors = in.readInt();
        if (numSelectors > 0) {
            req.m_selectors = new String[numSelectors];
            for (int ii = 0; ii < numSelectors; ++ii) {
                req.m_selectors[ii] = in.readUTF();
            }
        } else {
            req.m_selectors = null;
        }
        req.m_virtualClock = GSVirtualClock.unserialize(in);
        return req;
    }

    @Override
    public IMgram createMgram() throws IOException {
        if (this.m_transport == null) {
            this.m_transport = AgentRegistrar.getAgentRegistrar().getGSManager().getTransport();
        }
        return this.m_transport.createMgram(this);
    }

    @Override
    public String getUniqueKey() {
        return this.m_topic;
    }

    @Override
    public boolean preNodeQueueInsertionInterceptor(IndexedList list) {
        if (list.get(this.m_topic) != null) {
            list.remove(this.m_topic);
        }
        return true;
    }
}

