/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.gs.GSPropagationRule;
import progress.message.client.EGeneralException;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public final class GSRulesAdmin
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    public GSRulesAdmin(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "GSRulesAdmin" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block19: {
            try {
                Message msg = env.getMessage();
                int opCode = msg.readInt();
                if (this.DEBUG) {
                    this.debug("Entered GSRulesAdmin");
                }
                Message rep = new Message();
                try {
                    if (opCode == 1) {
                        String pattern = msg.readUTF();
                        Vector rules = this.m_reg.getGSManager().getGSRules(pattern);
                        int size = rules == null ? 0 : rules.size();
                        rep.writeInt(size);
                        Enumeration entries = rules.elements();
                        while (entries.hasMoreElements()) {
                            GSPropagationRule aRule = (GSPropagationRule)entries.nextElement();
                            rep.writeObject(aRule);
                        }
                    } else if (opCode == 2) {
                        String ruleTopic = msg.readUTF();
                        int num = msg.readInt();
                        Vector<String> toNodes = new Vector<String>();
                        if (num > 0) {
                            for (int i = 0; i < num; ++i) {
                                String aNode = msg.readUTF();
                                toNodes.addElement(aNode);
                            }
                        }
                        if (this.DEBUG) {
                            this.debug("setting rule for topic: " + ruleTopic);
                        }
                        this.m_reg.getGSManager().setRule(ruleTopic, toNodes);
                        rep.writeBoolean(true);
                    } else if (opCode == 3) {
                        String ruleTopic = msg.readUTF();
                        if (this.DEBUG) {
                            this.debug("deleting rule for topic: " + ruleTopic);
                        }
                        this.m_reg.getGSManager().deleteRule(ruleTopic, null);
                        rep.writeBoolean(true);
                    } else if (opCode == 4) {
                        boolean forwarding = msg.readBoolean();
                        this.m_reg.getGSManager().enableForwading(forwarding);
                        rep.writeBoolean(true);
                    }
                }
                catch (Exception e) {
                    rep = new Message();
                    rep.writeBoolean(false);
                    rep.writeObject(e);
                }
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block19;
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
    }
}

