/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.util.Counter;

public class GSTopicInfo {
    private String m_topic;
    private Hashtable m_selectorInfoList = new Hashtable();
    private int m_subscriberCount = 0;
    private int m_failureCode = -1;

    GSTopicInfo(String topic) {
        this.m_topic = topic;
    }

    boolean addOrUpdateSubscriber(boolean newSubscription, Vector addedSelectors, Vector removedSelectors) {
        int ii;
        boolean updateNeeded = false;
        if (addedSelectors != null) {
            for (ii = 0; ii < addedSelectors.size(); ++ii) {
                if (!this.addSelector((String)addedSelectors.get(ii))) continue;
                updateNeeded = true;
            }
        }
        if (removedSelectors != null) {
            for (ii = 0; ii < removedSelectors.size(); ++ii) {
                if (!this.removeSelector((String)removedSelectors.get(ii))) continue;
                updateNeeded = true;
            }
        }
        if (newSubscription) {
            ++this.m_subscriberCount;
        }
        return updateNeeded;
    }

    private boolean addSelector(String selector) {
        boolean updateNeeded = false;
        Counter selectorCount = (Counter)this.m_selectorInfoList.get(selector);
        if (selectorCount == null) {
            selectorCount = new Counter(0);
            updateNeeded = true;
        }
        selectorCount.increment();
        this.m_selectorInfoList.put(selector, selectorCount);
        return updateNeeded;
    }

    boolean deleteSubscriber(String[] selectors) {
        boolean updateNeeded = false;
        if (selectors != null) {
            for (int ii = 0; ii < selectors.length; ++ii) {
                if (!this.removeSelector(selectors[ii])) continue;
                updateNeeded = true;
            }
        }
        --this.m_subscriberCount;
        return updateNeeded;
    }

    private boolean removeSelector(String selector) {
        Counter selectorCount = (Counter)this.m_selectorInfoList.get(selector);
        if (selectorCount != null) {
            selectorCount.decrement();
            if (selectorCount.getIntValue() == 0) {
                this.m_selectorInfoList.remove(selector);
                selectorCount = null;
                return true;
            }
            return false;
        }
        return true;
    }

    Hashtable getSelectorInfoList() {
        return this.m_selectorInfoList;
    }

    int getNumSelectors() {
        return this.m_selectorInfoList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getSelectors() {
        String[] selectors = null;
        Hashtable hashtable = this.m_selectorInfoList;
        synchronized (hashtable) {
            if (!this.m_selectorInfoList.isEmpty()) {
                selectors = new String[this.m_selectorInfoList.size()];
                int ii = 0;
                Enumeration entries = this.m_selectorInfoList.keys();
                while (entries.hasMoreElements()) {
                    selectors[ii] = (String)entries.nextElement();
                    ++ii;
                }
            }
        }
        return selectors;
    }

    String getTopic() {
        return this.m_topic;
    }

    int getSubscriberCount() {
        return this.m_subscriberCount;
    }

    int getFailureCode() {
        return this.m_failureCode;
    }

    boolean subscribeHasFailed() {
        return this.m_failureCode != -1;
    }

    void setFailureCode(int failureCode) {
        this.m_failureCode = failureCode;
    }

    void unsetFailureCode() {
        this.m_failureCode = -1;
    }

    void dump() {
        System.out.println("        [GSTopicInfo Dump] for [topic] " + this.m_topic);
        System.out.println("            [user count] " + this.m_subscriberCount);
        Enumeration enums = this.m_selectorInfoList.elements();
        while (enums.hasMoreElements()) {
            ((Counter)enums.nextElement()).toString();
        }
    }
}

