/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.broker.INeighbor;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.broker.gs.GSNodeInfo;
import progress.message.broker.gs.GSPingMgramWrapper;
import progress.message.broker.gs.GSReconciliationMgramWrapper;
import progress.message.broker.gs.GSRequest;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.gs.IGSRemoteRequest;
import progress.message.broker.gs.NeighborSwizzlerSession;
import progress.message.client.ENetworkFailure;
import progress.message.gr.RouterManager;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public class GSTransport
extends DebugObject {
    public static final int SUB_LIST_FRAG_SIZE = 32768;
    public static final String GSA_SUBJECT_PREFIX = "$ISYS.GSA.";
    public static final String RECONCILE_SUBJECT = "$ISYS.GSA.globalReconcile";
    public static final String RECONCILED_SUBJECTS = "$ISYS.GSA.RECONCILED TOPICS";
    public static final String RECONCILE_REJECTS_SUBJECT = "$ISYS.GSA.globalReconcileRejects";
    public static final String IB_RECONCILE_SUBJECT = "$ISYS.GSA.globalIBReconcile";
    public static final String SUBSCRIBE_SUBJECT = "$ISYS.GSA.globalSubscribe";
    public static final String PING_SUBJECT = "$ISYS.GSA.globalPingSubscriptions";
    public static final String REQUEST_FAILURE_SUBJECT = "$ISYS.GSA.globalRequestFailure";
    public static final String UNSUBSCRIBE_SUBJECT = "$ISYS.GSA.globalUnsubscribe";
    public static final String ADMIN_RECONCILE_SUBJECT = "$ISYS.GSA.globalAdminReconcile";
    public static final String ADMIN_DELETE_SUBJECT = "$ISYS.GSA.globalAdminDelete";
    public static final String GS_EXPIRABLE_SUBJECT = "$ISYS.GSA.expirableSubject";
    public static final int GS_UPDATE = 0;
    public static final int GS_SUBSCRIBE = 1;
    public static final int GS_UNSUBSCRIBE = 2;
    public static final int GS_XFER_MASK_OFFSET = 1;
    public static final int GS_XFER_START_MASK = 1;
    public static final int GS_XFER_END_MASK = 2;
    public static final int GS_XFER_INITIATE_REVERSE_RECONCILE_MASK = 4;
    public static final int GS_XFER_SUPPRESS_FAILURE_NOTIFICATION_MASK = 8;
    public static final int GS_DELETE_MANUAL_REASON = 0;
    public static final int GS_DELETE_EXPIRED_REASON = 1;
    private static final byte CURRENT_VERSION = 0;
    AgentRegistrar m_reg;
    IMessageProtection m_mp = null;
    private NeighborSwizzlerSession m_ibs;
    private static final long m_clientTracking = 1L;

    GSTransport(AgentRegistrar reg) {
        super("GSTransport");
        try {
            this.m_reg = reg;
            this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            throw new EAssertFailure(e);
        }
    }

    public void sendRequest(IGSRemoteRequest request, IFlowController flowController) throws InterruptedException {
        try {
            IMgram mgram = request.createMgram();
            if (!mgram.isGuarenteed()) {
                long tracking = this.getNextClientTracking();
                mgram.setGuarenteed(tracking);
            }
            AgentRegistrar.getAgentRegistrar().getQueueProc().newMgram(mgram, null, flowController);
        }
        catch (IOException e) {
            System.out.println("sendRequest returns IOException");
        }
    }

    public IMgram createMgram(GSRequest req) throws IOException {
        int opCode = req.getOpCode();
        boolean persistent = opCode == 1 || opCode == 2;
        IMgram mgram = this.createMgram(req.getRemoteNodeName(), this.getSubject(opCode), persistent);
        ObjectOutput out = mgram.getPayloadOutputStreamHandle();
        req.serialize(out);
        return mgram;
    }

    public void sendReconciliationList(String nodeName, GSNodeInfo ni, boolean initiateReverseReconcile) {
        try {
            GSReconciliationMgramWrapper request;
            Hashtable h = null;
            Enumeration enu = null;
            if (ni != null) {
                h = ni.getRequestList();
                enu = h.elements();
            }
            IMgram mgram = this.createMgram(nodeName, RECONCILE_SUBJECT, false);
            int mask = 1;
            if (!initiateReverseReconcile) {
                mask |= 8;
            }
            int seqnr = 0;
            ObjectOutput out = mgram.getPayloadOutputStreamHandle();
            seqnr = GSTransport.outWriteConfigDetails(mask, out, seqnr);
            GSVirtualClock masterReconcileClock = GSVirtualClock.assignVirtualClock();
            this.m_reg.getGSManager().onNodeReconciliation(nodeName, masterReconcileClock);
            masterReconcileClock.serialize(out);
            while (enu != null && enu.hasMoreElements()) {
                GSRequest req = (GSRequest)enu.nextElement();
                req.serialize(out, false);
                if (mgram.getBodyLength() < 32768) continue;
                request = new GSReconciliationMgramWrapper(mgram, nodeName, seqnr - 1, initiateReverseReconcile);
                this.m_reg.getGSManager().getRequestSender().sendRequest(request);
                mgram = this.createMgram(ni.getNodeName(), RECONCILE_SUBJECT, false);
                out = mgram.getPayloadOutputStreamHandle();
                mask &= 0xFFFFFFFE;
                seqnr = GSTransport.outWriteConfigDetails(mask |= 8, out, seqnr);
                masterReconcileClock.serialize(out);
            }
            mask |= 2;
            if (initiateReverseReconcile) {
                mask |= 4;
            }
            byte[] raw = mgram.getRawBody();
            ArrayUtil.writeInt(raw, 1, mask);
            request = new GSReconciliationMgramWrapper(mgram, nodeName, seqnr - 1, initiateReverseReconcile);
            this.m_reg.getGSManager().getRequestSender().sendRequest(request);
        }
        catch (IOException e) {
            System.out.println("GSASubXfer returns IOException");
        }
    }

    private static int outWriteConfigDetails(int mask, DataOutput out, int seqnrParam) throws IOException {
        int seqnr = seqnrParam;
        out.writeByte(0);
        out.writeInt(mask);
        out.writeInt(seqnr++);
        out.writeUTF(Config.ROUTING_NODE_NAME);
        out.writeUTF(Config.BROKER_NAME);
        return seqnr;
    }

    IMgram createMgram(String nodeName, String reqSubject) {
        return this.createMgram(nodeName, reqSubject, false);
    }

    IMgram createMgram(String nodeName, String reqSubject, boolean persistent) {
        IMgram mgram = MgramFactory.getMgramFactory().createMgram(true);
        mgram.setSubject(new Subject(reqSubject), 3);
        mgram.setType((byte)2);
        mgram.createSidebandDataIfNeeded();
        mgram.getRoutingHandle().setRouting(nodeName);
        mgram.setPriority((byte)0);
        mgram.setRouteLimit(7);
        if (persistent) {
            mgram.setJMSPersistent(true);
            long tracking = this.getNextClientTracking();
            mgram.setGuarenteed(tracking);
        }
        if (Config.ENABLE_QOPSECURITY) {
            mgram.setMgramSecure(this.m_mp);
            mgram.setSecurityAttribute((byte)0);
        } else {
            mgram.setMgramNonSecure();
        }
        return mgram;
    }

    private String getSubject(int opCode) {
        switch (opCode) {
            case 0: 
            case 1: {
                return SUBSCRIBE_SUBJECT;
            }
            case 2: {
                return UNSUBSCRIBE_SUBJECT;
            }
        }
        return "EH";
    }

    public boolean isGSASubject(String subject) {
        return subject != null && subject.startsWith(GSA_SUBJECT_PREFIX);
    }

    public boolean isGSASubscribe(IMgram mgram) {
        String subject = mgram.getSubject().getSubjectString();
        return subject != null && subject.equals(SUBSCRIBE_SUBJECT);
    }

    public boolean isGSAUnsubscribe(IMgram mgram) {
        String subject = mgram.getSubject().getSubjectString();
        return subject != null && subject.equals(UNSUBSCRIBE_SUBJECT);
    }

    public boolean isGSAPing(IMgram mgram) {
        String subject = mgram.getSubject().getSubjectString();
        return subject != null && subject.equals(PING_SUBJECT);
    }

    public boolean isGSAReconcile(IMgram mgram) {
        String subject = mgram.getSubject().getSubjectString();
        return subject != null && subject.equals(RECONCILE_SUBJECT);
    }

    public IMgram removeProhibitedSubscriptions(IClientContext fromCC, IMgram mgram) {
        IMgram rejectsMgram = null;
        int rejectCount = 0;
        int rejectReason = 19;
        GSVirtualClock masterReconcileClock = null;
        String homeBroker = null;
        String homeNode = null;
        int seqnr = 0;
        try {
            if (fromCC.isInterbroker()) {
                return null;
            }
            ObjectInput in = mgram.getPayloadInputStreamHandle();
            byte version = in.readByte();
            int mask = in.readInt();
            seqnr = in.readInt();
            homeNode = in.readUTF();
            homeBroker = in.readUTF();
            masterReconcileClock = GSVirtualClock.unserialize(in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(version);
            out.writeInt(mask);
            out.writeInt(seqnr);
            out.writeUTF(homeNode);
            out.writeUTF(homeBroker);
            masterReconcileClock.serialize(out);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            DataOutputStream rejects = new DataOutputStream(baos2);
            rejects.writeByte(version);
            rejects.writeInt(rejectReason);
            rejects.writeUTF(Config.BROKER_NAME);
            rejects.writeUTF(Config.ROUTING_NODE_NAME);
            rejects.writeUTF(homeNode);
            rejects.writeUTF(homeBroker);
            masterReconcileClock.serialize(rejects);
            while (true) {
                GSRequest req = null;
                try {
                    req = GSRequest.deserialize(in, false);
                }
                catch (EOFException e) {
                    break;
                }
                boolean ok = this.m_reg.getGSManager().okToSubscribe(homeNode, req.getTopic());
                if (this.DEBUG) {
                    this.debug("GS Reconcile:pre-check " + (ok ? "passed" : "failed") + ",homeNode=" + homeNode + ",homeBroker=" + homeBroker + ",topic=" + req.getTopic() + ",vc=" + req.getVirtualClock());
                }
                if (ok) {
                    req.serialize(out, false);
                    continue;
                }
                ++rejectCount;
                req.serialize(rejects, false);
            }
            baos.close();
            baos2.close();
            if (rejectCount > 0) {
                byte[] revision = baos.toByteArray();
                mgram.setBody(revision);
                mgram.sync();
                rejectsMgram = this.createMgram(null, RECONCILE_REJECTS_SUBJECT, false);
                byte[] rejections = baos2.toByteArray();
                rejectsMgram.setBody(rejections);
                rejectsMgram.sync();
            }
        }
        catch (EClientNotRegistered e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        catch (IOException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        return rejectsMgram;
    }

    public void sendGSIBReconciliationList(INeighbor n) {
        try {
            if (this.m_ibs == null) {
                this.m_ibs = new NeighborSwizzlerSession(this.m_reg.getAdminConnection());
            }
            int mask = 1;
            int seqnr = 0;
            long ncid = AddrUtil.stringToClientId(n.getName(), "Broker");
            Message m = new Message(IB_RECONCILE_SUBJECT);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(0);
            out.writeInt(mask);
            out.writeInt(seqnr);
            out.writeUTF(Config.BROKER_NAME);
            Enumeration enu = this.m_reg.getGSManager().getAllRemoteSubscriptionsPerBroker();
            while (enu.hasMoreElements()) {
                BrokerSubscription sub = (BrokerSubscription)enu.nextElement();
                String appid = sub.getClient().getAppid();
                String homeNode = sub.getClient().getRemoteNode();
                String homeBroker = RouterManager.getRemoteBrokerFromGSAppID(appid);
                GSRequest req = new GSRequest(homeNode, homeBroker, Config.ROUTING_NODE_NAME, sub.getTopic(), sub.getSelectorStrings(), 1, sub.getVirtualClock());
                req.serialize(out);
                baos.flush();
                if (baos.size() < 32768) continue;
                baos.close();
                m.setBody(baos.toByteArray());
                this.m_ibs.publish(ncid, m, 0, false);
                m = new Message(IB_RECONCILE_SUBJECT);
                baos = new ByteArrayOutputStream();
                out = new DataOutputStream(baos);
                out.writeByte(0);
                out.writeInt(mask &= 0xFFFFFFFE);
                out.writeInt(seqnr++);
                out.writeUTF(Config.BROKER_NAME);
            }
            baos.close();
            byte[] raw = baos.toByteArray();
            ArrayUtil.writeInt(raw, 1, mask |= 2);
            m.setBody(raw);
            this.m_ibs.publish(ncid, m, 0, false);
        }
        catch (ENetworkFailure enf) {
            if (!Broker.isInShutdown()) {
                SessionConfig.logMessage(enf, SessionConfig.getLevelWarning());
            }
        }
        catch (IOException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPing(BrokerSubscription bs) {
        try {
            MergedBrokerSubscription mbs = (MergedBrokerSubscription)bs;
            String homeNode = mbs.getClient().getTargetNodeName();
            String homeBroker = null;
            LongHashTable subs = mbs.getContributors();
            LongHashTable shallowClone = null;
            LongHashTable longHashTable = subs;
            synchronized (longHashTable) {
                shallowClone = (LongHashTable)subs.clone();
            }
            IMgram mgram = this.createMgram(homeNode, PING_SUBJECT, false);
            mgram.setTTE(this.getPingTTE());
            ObjectOutput out = mgram.getPayloadOutputStreamHandle();
            out.writeByte(0);
            out.writeUTF(Config.ROUTING_NODE_NAME);
            out.writeUTF(Config.BROKER_NAME);
            Enumeration entries = shallowClone.elements();
            while (entries.hasMoreElements()) {
                BrokerSubscription bbs = (BrokerSubscription)entries.nextElement();
                String appid = bbs.getClient().getAppid();
                homeBroker = RouterManager.getRemoteBrokerFromGSAppID(appid);
                out.writeUTF(homeNode);
                out.writeUTF(homeBroker);
                out.writeUTF(bbs.getTopic());
                bbs.getVirtualClock().serialize(out);
            }
            GSPingMgramWrapper request = new GSPingMgramWrapper(mgram, homeNode, bs.getTopic());
            this.m_reg.getGSManager().getRequestSender().sendRequest(request);
        }
        catch (IOException e) {
            System.out.println("sendPing:" + e);
        }
    }

    private long getPingTTE() {
        long secsTTL = Config.QUEUE_CLEANUP_INTERVAL;
        if (secsTTL == 0L) {
            secsTTL = 600L;
        }
        return System.currentTimeMillis() + secsTTL * 1000L;
    }

    public void sendRequestFailure(GSRequest gsRequest, String remoteNode, int reason, String reportingBroker) {
        IMgram reply = this.createMgram(null, REQUEST_FAILURE_SUBJECT, false);
        ObjectOutput out = reply.getPayloadOutputStreamHandle();
        try {
            out.writeByte(0);
            out.writeInt(gsRequest.getOpCode());
            out.writeUTF(remoteNode);
            out.writeUTF(gsRequest.getHomeBrokerName());
            out.writeUTF(reportingBroker);
            out.writeUTF(gsRequest.getTopic());
            GSVirtualClock vClock = gsRequest.getVirtualClock();
            vClock.serialize(out);
            out.writeInt(reason);
        }
        catch (IOException ex) {
            if (this.DEBUG) {
                this.debug("sendRequestFailure: can't create a reply to a failed remote subscribe request");
            }
            return;
        }
        Envelope env = new Envelope(new Message(REQUEST_FAILURE_SUBJECT, reply.getRawBody()));
        Label label = new Label();
        label.setPersistent(true);
        env.setLabel(label);
        try {
            AgentRegistrar.getAgentRegistrar().getAdminSession().publishInternal(env, 0, true, true);
        }
        catch (ENetworkFailure enf) {
            if (!Broker.isInShutdown()) {
                SessionConfig.logMessage(enf, SessionConfig.getLevelWarning());
                throw new EAssertFailure("internal error: sendRequestFailure: cannot send admin event");
            }
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            throw new EAssertFailure("internal error: sendRequestFailure: cannot send admin event");
        }
    }

    public long getNextClientTracking() {
        return 1L;
    }
}

