/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.CounterManager;
import progress.message.broker.gs.GSVirtualClock;

class GSVirtualClockAssigner {
    private CounterManager m_cm;
    private long m_low = -1L;
    private long m_high = -1L;
    private static final long LOWWRAP = 65535L;

    public static GSVirtualClock assignVirtualClock() {
        return GSVirtualClockLazyHolder.SINGLETON.assign();
    }

    GSVirtualClockAssigner(CounterManager cm) {
        this.m_cm = cm;
    }

    GSVirtualClock assign() {
        if (this.m_high == -1L) {
            this.m_high = this.m_cm.getNextVirtualClockCounter();
        }
        ++this.m_low;
        if (this.m_low > 65535L) {
            this.m_low = 0L;
            this.m_high = this.m_cm.getNextVirtualClockCounter();
        }
        return new GSVirtualClock(this.m_high << 16 | this.m_low);
    }

    private static class GSVirtualClockLazyHolder {
        private static final GSVirtualClockAssigner SINGLETON = new GSVirtualClockAssigner(AgentRegistrar.getAgentRegistrar().getCounterManager());

        private GSVirtualClockLazyHolder() {
        }
    }
}

