/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt;

import java.io.IOException;
import progress.message.broker.Config;
import progress.message.broker.IAcceptor;
import progress.message.broker.IBrokerConnection;
import progress.message.broker.mqtt.IMqttMessageListener;
import progress.message.broker.mqtt.MqttListener;
import progress.message.broker.mqtt.MqttRegistrar;
import progress.message.broker.mqtt.MqttSender;
import progress.message.broker.mqtt.MqttSession;
import progress.message.broker.mqtt.proto.ConnectMessage;
import progress.message.broker.mqtt.proto.MqttLastWillTestament;
import progress.message.broker.mqtt.proto.MqttMessage;
import progress.message.broker.mqtt.proto.MqttVersion;
import progress.message.net.ISocket;
import progress.message.zclient.BaseConnection;

public class MqttBrokerConnection
extends BaseConnection
implements IBrokerConnection,
IMqttMessageListener {
    private final IAcceptor m_acceptor;
    private final long m_socketId;
    private final MqttSender m_sender;
    private final MqttListener m_listener;
    private final Object m_lock = new Object();
    private boolean m_closed;
    private MqttSession m_session;
    private MqttVersion m_version;
    private MqttLastWillTestament m_lastWillTestament;
    private String m_clientId;
    private boolean m_connected;
    private int m_keepAliveInterval;
    private boolean m_cleanSession;
    private int m_maxSendBufferSize = Config.MAX_SEND_IO_BUFFER_SIZE;
    private int m_maxRcvBufferSize = Config.MAX_RCV_IO_BUFFER_SIZE;
    private int m_minSendBufferSize = Config.MIN_SEND_IO_BUFFER_SIZE;
    private int m_minRcvBufferSize = Config.MIN_RCV_IO_BUFFER_SIZE;
    private int m_initialSendBufferSize = Config.INITIAL_SEND_IO_BUFFER_SIZE;
    private int m_initialRcvBufferSize = Config.INITIAL_RCV_IO_BUFFER_SIZE;

    public MqttBrokerConnection(ISocket socket, IAcceptor acceptor, long socketId) throws IOException {
        this.m_socket = socket;
        this.m_acceptor = acceptor;
        this.m_socketId = socketId;
        this.m_sender = new MqttSender(this);
        this.m_listener = new MqttListener(this);
    }

    public MqttSession getSession() {
        return this.m_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectInternal(ConnectMessage connectMessage) throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_version = connectMessage.getVersion();
            this.m_cleanSession = connectMessage.isCleanSession();
            this.m_clientId = connectMessage.getClientID();
            this.m_keepAliveInterval = connectMessage.getKeepAlive();
            this.m_lastWillTestament = connectMessage.getLastWillTestament();
            String username = connectMessage.getUsername() != null ? connectMessage.getUsername() : "";
            String password = connectMessage.getPassword() != null ? connectMessage.getPassword() : "";
            this.m_session = !this.m_cleanSession && MqttRegistrar.isSessionPresent(this.m_clientId) ? MqttRegistrar.restoreSession(this, this.m_clientId, username, password) : MqttRegistrar.createSession(this, this.m_clientId, username, password);
            this.configureSocketTimeout();
            this.m_sender.startIfNotStartedOrShutdown();
            this.m_connected = true;
        }
    }

    private void configureSocketTimeout() throws IOException {
        int keepAliveWait = this.m_keepAliveInterval * 1000 * 2;
        this.m_socket.setSoTimeout(keepAliveWait);
    }

    public MqttLastWillTestament getLastWillTestament() {
        return this.m_lastWillTestament;
    }

    public boolean isCleanSession() {
        return this.m_cleanSession;
    }

    public String getClientId() {
        return this.m_clientId;
    }

    public int getKeepAliveInterval() {
        return this.m_keepAliveInterval;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public void send(MqttMessage message) throws IOException {
        this.m_sender.send(message);
    }

    @Override
    public void messageReceived(MqttMessage message) {
    }

    @Override
    public void messageSent(MqttMessage message) {
    }

    @Override
    public IAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    @Override
    public MqttSender getSender() {
        return this.m_sender;
    }

    @Override
    public MqttListener getListener() {
        return this.m_listener;
    }

    @Override
    public int getMaxSendBufferSize() {
        return this.m_maxSendBufferSize;
    }

    @Override
    public void setMaxSendBufferSize(int size) {
        this.m_maxSendBufferSize = size;
    }

    @Override
    public int getMinSendBufferSize() {
        return this.m_minSendBufferSize;
    }

    @Override
    public void setMinSendBufferSize(int size) {
        this.m_minSendBufferSize = size;
    }

    @Override
    public int getMaxRcvBufferSize() {
        return this.m_maxRcvBufferSize;
    }

    @Override
    public void setMaxRcvBufferSize(int size) {
        this.m_maxRcvBufferSize = size;
    }

    @Override
    public int getMinRcvBufferSize() {
        return this.m_minRcvBufferSize;
    }

    @Override
    public void setMinRcvBufferSize(int size) {
        this.m_minRcvBufferSize = size;
    }

    @Override
    public int getInitialSendBufferSize() {
        return this.m_initialSendBufferSize;
    }

    @Override
    public void setInitialSendBufferSize(int size) {
        this.m_initialSendBufferSize = size;
    }

    @Override
    public int getInitialRcvBufferSize() {
        return this.m_initialRcvBufferSize;
    }

    @Override
    public void setInitialRcvBufferSize(int size) {
        this.m_initialRcvBufferSize = size;
    }

    @Override
    public void close() {
        this.close(this.m_cleanSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_closed) {
                return;
            }
            try {
                if (this.m_clientId != null) {
                    MqttRegistrar.clearSession(this.m_clientId, force);
                }
                if (this.m_sender != null) {
                    this.m_sender.shutdown();
                }
                if (this.m_listener != null) {
                    this.m_listener.shutdown();
                }
                super.close();
            }
            finally {
                this.m_connected = false;
                this.m_closed = true;
            }
        }
    }

    @Override
    public void fatalError() {
        if (this.isConnected() && this.getLastWillTestament() != null && this.getSession() != null) {
            this.getSession().sendLastWillMessage(this.getLastWillTestament());
        }
        this.close();
    }

    public MqttVersion getVersion() {
        return this.m_version;
    }

    public long getSocketId() {
        return this.m_socketId;
    }

    @Override
    public String toString() {
        return "MqttBrokerConnection " + this.m_socketId;
    }
}

