/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.agent;

import progress.message.broker.mqtt.agent.MqttSubscriptionHandler;
import progress.message.client.EGeneralException;
import progress.message.zclient.Connection;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Subscription;

public class MqttAgentSubscription {
    private final Connection m_consumerConnection;
    private final MessageHandler m_messageHandler;
    private final Subscription m_subscription;
    private final MqttSubscriptionHandler m_subscriptionHandler;

    public MqttAgentSubscription(Connection consumerConnection, MessageHandler messageHandler, Subscription subscription, MqttSubscriptionHandler subscriptionHandler) {
        this.m_consumerConnection = consumerConnection;
        this.m_messageHandler = messageHandler;
        this.m_subscription = subscription;
        this.m_subscriptionHandler = subscriptionHandler;
    }

    public Connection getConsumerConnection() {
        return this.m_consumerConnection;
    }

    public MessageHandler getMessageHandler() {
        return this.m_messageHandler;
    }

    public Subscription getSubscription() {
        return this.m_subscription;
    }

    public MqttSubscriptionHandler getSubscriptionHandler() {
        return this.m_subscriptionHandler;
    }

    public void unsubscribe() throws EGeneralException {
        if (this.m_consumerConnection.isConnected()) {
            this.m_subscription.cancel();
            this.m_messageHandler.unbind(this.m_subscription.getSubject(), (IMessageHandler)this.m_subscriptionHandler);
            this.m_consumerConnection.disconnect(false);
        }
    }
}

