/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import progress.message.broker.mqtt.codec.DemuxDecoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.ConnectMessage;
import progress.message.broker.mqtt.proto.MqttConnectException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.MqttTopic;
import progress.message.broker.mqtt.proto.MqttVersion;
import progress.message.util.server.IByteBuffer;
import progress.message.zclient.ProgressSecureRandom;

public class ConnectDecoder
extends DemuxDecoder<ConnectMessage> {
    public static int MAX_CLIENT_ID_LENGTH;
    public static final String MQTT_MAX_CLIENT_ID_LENGTH_PROPERTY = "mqtt.clientid.length";
    private static final Pattern CLIENT_ID_PATTERN;
    private static final String UNDERLINE = "_";

    @Override
    ConnectMessage decode(IByteBuffer in) throws EOFException {
        int readed;
        boolean userFlag;
        ConnectMessage message = new ConnectMessage();
        if (!this.decodeCommonHeader(message, 0, in)) {
            return null;
        }
        int remainingLength = message.getRemainingLength();
        int start = in.countRead();
        int protocolNameLen = in.readUnsignedShort();
        if (in.countUnread() < 8) {
            throw new MqttConnectException("Invalid protocol version", 1);
        }
        byte[] encProtoName = new byte[protocolNameLen];
        in.read(encProtoName);
        String protoName = new String(encProtoName, StandardCharsets.UTF_8);
        byte level = in.readByte();
        message.setVersion(MqttVersion.fromProtocolNameAndLevel(protoName, level));
        byte connFlags = in.readByte();
        boolean cleanSession = (connFlags & 2) >> 1 == 1;
        boolean willFlag = (connFlags & 4) >> 2 == 1;
        byte willQos = (byte)((connFlags & 0x18) >> 3);
        boolean willRetain = (connFlags & 0x20) >> 5 == 1;
        boolean passwordFlag = (connFlags & 0x40) >> 6 == 1;
        boolean bl = userFlag = (connFlags & 0x80) >> 7 == 1;
        if (!userFlag && passwordFlag) {
            throw new MqttConnectException("Expected password flag to true only if the user flag is true", 4);
        }
        message.setCleanSession(cleanSession);
        message.setWillFlag(willFlag);
        message.setWillQos(MqttQoS.valueOf(willQos));
        message.setWillRetain(willRetain);
        message.setPasswordFlag(passwordFlag);
        message.setUserFlag(userFlag);
        int keepAlive = in.readUnsignedShort();
        message.setKeepAlive(keepAlive);
        String clientID = MqttCodecUtils.decodeString(in);
        String normalizedClientID = this.normalizeClientId(clientID, cleanSession);
        message.setClientID(normalizedClientID);
        if (clientID == null) {
            return message;
        }
        if (willFlag) {
            String willTopic = MqttCodecUtils.decodeString(in);
            if (willTopic == null) {
                return message;
            }
            message.setWillTopic(new MqttTopic(willTopic));
            int messageSize = in.readUnsignedShort();
            if (in.countUnread() < messageSize) {
                return message;
            }
            byte[] messagePayload = new byte[messageSize];
            in.read(messagePayload);
            message.setWillMessage(messagePayload);
        }
        if ((readed = in.countRead() - start) == remainingLength) {
            return message;
        }
        if (userFlag) {
            String userName = MqttCodecUtils.decodeString(in);
            if (userName == null) {
                return message;
            }
            message.setUsername(userName);
        }
        if ((readed = in.countRead() - start) == remainingLength) {
            return message;
        }
        if (passwordFlag) {
            String password = MqttCodecUtils.decodeString(in);
            if (password == null) {
                return message;
            }
            message.setPassword(password);
        }
        return message;
    }

    private String normalizeClientId(String clientIdParam, boolean cleanSession) {
        String clientId = clientIdParam;
        if (clientId == null || clientId.isEmpty()) {
            if (cleanSession) {
                clientId = Long.toString(ProgressSecureRandom.theSecureRandom().nextLong());
            } else {
                throw new MqttConnectException("Client ID is empty and clean session is disabled", 2);
            }
        }
        if (clientId.length() > MAX_CLIENT_ID_LENGTH) {
            throw new MqttConnectException("Invalid client ID length = " + clientId.length(), 2);
        }
        Matcher matcher = CLIENT_ID_PATTERN.matcher(clientId);
        clientId = matcher.replaceAll(UNDERLINE);
        return clientId;
    }

    static {
        int maxLength;
        MAX_CLIENT_ID_LENGTH = Short.MAX_VALUE;
        String maxLengthProperty = System.getProperty(MQTT_MAX_CLIENT_ID_LENGTH_PROPERTY);
        if (maxLengthProperty != null && MAX_CLIENT_ID_LENGTH > (maxLength = Integer.parseInt(maxLengthProperty))) {
            MAX_CLIENT_ID_LENGTH = maxLength;
        }
        CLIENT_ID_PATTERN = Pattern.compile("[#\\$%\\*\\./]");
    }
}

