/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import java.util.HashMap;
import java.util.Map;
import progress.message.broker.mqtt.codec.ConnAckDecoder;
import progress.message.broker.mqtt.codec.ConnectDecoder;
import progress.message.broker.mqtt.codec.DemuxDecoder;
import progress.message.broker.mqtt.codec.DisconnectDecoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.codec.PingReqDecoder;
import progress.message.broker.mqtt.codec.PingRespDecoder;
import progress.message.broker.mqtt.codec.PubAckDecoder;
import progress.message.broker.mqtt.codec.PubCompDecoder;
import progress.message.broker.mqtt.codec.PubRecDecoder;
import progress.message.broker.mqtt.codec.PubRelDecoder;
import progress.message.broker.mqtt.codec.PublishDecoder;
import progress.message.broker.mqtt.codec.SubAckDecoder;
import progress.message.broker.mqtt.codec.SubscribeDecoder;
import progress.message.broker.mqtt.codec.UnsubAckDecoder;
import progress.message.broker.mqtt.codec.UnsubscribeDecoder;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttMessage;
import progress.message.util.server.IByteBuffer;

public class MqttDecoder {
    private static Map<Byte, DemuxDecoder> m_decoderMap = new HashMap<Byte, DemuxDecoder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MqttMessage decode(IByteBuffer in) throws MqttException {
        try {
            if (!MqttCodecUtils.checkHeaderAvailability(in)) {
                return null;
            }
            byte messageType = MqttCodecUtils.readMessageType(in);
            DemuxDecoder decoder = m_decoderMap.get(messageType);
            if (decoder == null) {
                throw new MqttException("Can't find any suitable decoder for message type = " + messageType);
            }
            in.markRead();
            MqttMessage message = null;
            try {
                message = (MqttMessage)decoder.decode(in);
            }
            finally {
                if (message == null) {
                    in.gotoMarkedRead();
                }
            }
            return message;
        }
        catch (EOFException ex) {
            throw new MqttException(ex);
        }
    }

    static {
        m_decoderMap.put((byte)1, new ConnectDecoder());
        m_decoderMap.put((byte)2, new ConnAckDecoder());
        m_decoderMap.put((byte)3, new PublishDecoder());
        m_decoderMap.put((byte)4, new PubAckDecoder());
        m_decoderMap.put((byte)8, new SubscribeDecoder());
        m_decoderMap.put((byte)9, new SubAckDecoder());
        m_decoderMap.put((byte)10, new UnsubscribeDecoder());
        m_decoderMap.put((byte)14, new DisconnectDecoder());
        m_decoderMap.put((byte)12, new PingReqDecoder());
        m_decoderMap.put((byte)13, new PingRespDecoder());
        m_decoderMap.put((byte)11, new UnsubAckDecoder());
        m_decoderMap.put((byte)7, new PubCompDecoder());
        m_decoderMap.put((byte)5, new PubRecDecoder());
        m_decoderMap.put((byte)6, new PubRelDecoder());
    }
}

