/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.util.HashMap;
import java.util.Map;
import progress.message.broker.mqtt.codec.ConnAckEncoder;
import progress.message.broker.mqtt.codec.ConnectEncoder;
import progress.message.broker.mqtt.codec.DemuxEncoder;
import progress.message.broker.mqtt.codec.DisconnectEncoder;
import progress.message.broker.mqtt.codec.PingReqEncoder;
import progress.message.broker.mqtt.codec.PingRespEncoder;
import progress.message.broker.mqtt.codec.PubAckEncoder;
import progress.message.broker.mqtt.codec.PubCompEncoder;
import progress.message.broker.mqtt.codec.PubRecEncoder;
import progress.message.broker.mqtt.codec.PubRelEncoder;
import progress.message.broker.mqtt.codec.PublishEncoder;
import progress.message.broker.mqtt.codec.SubAckEncoder;
import progress.message.broker.mqtt.codec.SubscribeEncoder;
import progress.message.broker.mqtt.codec.UnsubAckEncoder;
import progress.message.broker.mqtt.codec.UnsubscribeEncoder;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttMessage;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

public class MqttEncoder {
    private static Map<Byte, DemuxEncoder> m_encoderMap = new HashMap<Byte, DemuxEncoder>();

    public static IByteBuffer encode(MqttMessage msg) throws MqttException {
        ByteBuffer bb = msg.getRemainingLength() > 0 ? new ByteBuffer(2 + msg.getRemainingLength()) : new ByteBuffer();
        MqttEncoder.encode(msg, bb);
        return bb;
    }

    private static void encode(MqttMessage msg, IByteBuffer bb) throws MqttException {
        DemuxEncoder encoder = m_encoderMap.get(msg.getMessageType());
        if (encoder == null) {
            throw new MqttException("Can't find any suitable decoder for message type = " + msg.getMessageType());
        }
        encoder.encode(msg, bb);
    }

    static {
        m_encoderMap.put((byte)1, new ConnectEncoder());
        m_encoderMap.put((byte)2, new ConnAckEncoder());
        m_encoderMap.put((byte)3, new PublishEncoder());
        m_encoderMap.put((byte)4, new PubAckEncoder());
        m_encoderMap.put((byte)8, new SubscribeEncoder());
        m_encoderMap.put((byte)9, new SubAckEncoder());
        m_encoderMap.put((byte)10, new UnsubscribeEncoder());
        m_encoderMap.put((byte)14, new DisconnectEncoder());
        m_encoderMap.put((byte)12, new PingReqEncoder());
        m_encoderMap.put((byte)13, new PingRespEncoder());
        m_encoderMap.put((byte)11, new UnsubAckEncoder());
        m_encoderMap.put((byte)7, new PubCompEncoder());
        m_encoderMap.put((byte)5, new PubRecEncoder());
        m_encoderMap.put((byte)6, new PubRelEncoder());
    }
}

