/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import progress.message.broker.mqtt.proto.MqttException;

public class MqttTopicValidator {
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String TOPIC_LEVEL_SEPARATOR = "/";
    public static final String MULTI_LEVEL_WILDCARD_PATTERN = "/#";
    private static final int TOPIC_MIN_LEN = 1;
    private static final int TOPIC_MAX_LEN = 65536;
    private static final char NUL = '\u0000';

    public static void validate(String topic, boolean wildcardsAllowed) {
        int topicLen = topic.length();
        if (topicLen < 1 || topicLen > 65536) {
            throw new MqttException(String.format("Invalid topic length, should be in range[%d, %d]!", 1, 65536));
        }
        if (wildcardsAllowed) {
            if (MULTI_LEVEL_WILDCARD.equals(topic) || SINGLE_LEVEL_WILDCARD.equals(topic)) {
                return;
            }
            if (topic.contains(MULTI_LEVEL_WILDCARD) && !topic.endsWith(MULTI_LEVEL_WILDCARD_PATTERN)) {
                throw new MqttException(String.format("Invalid usage of multi-level wildcard in topic string = %s", topic));
            }
            if (topic.indexOf(MULTI_LEVEL_WILDCARD) >= 0 && topic.indexOf(MULTI_LEVEL_WILDCARD) != topic.lastIndexOf(MULTI_LEVEL_WILDCARD)) {
                throw new MqttException(String.format("Invalid usage of multi-level wildcard in topic string = %s", topic));
            }
            MqttTopicValidator.validateSingleLevelWildcard(topic);
        } else if (topic.contains(SINGLE_LEVEL_WILDCARD) || topic.contains(MULTI_LEVEL_WILDCARD)) {
            throw new MqttException(String.format("The topic name MUST NOT contain any wildcard characters (#+) = %s", topic));
        }
    }

    private static void validateSingleLevelWildcard(String topic) {
        char singleLevelWildcardChar = SINGLE_LEVEL_WILDCARD.charAt(0);
        char topicLevelSeparatorChar = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] chars = topic.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            char next;
            char prev = i - 1 >= 0 ? chars[i - 1] : (char)'\u0000';
            char c = next = i + 1 < length ? chars[i + 1] : (char)'\u0000';
            if (chars[i] != singleLevelWildcardChar || (prev == topicLevelSeparatorChar || prev == '\u0000') && (next == topicLevelSeparatorChar || next == '\u0000')) continue;
            throw new MqttException(String.format("Invalid usage of single-level wildcard in topic string = %s", topic));
        }
    }
}

