/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import progress.message.broker.mqtt.codec.DemuxDecoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.MqttTopic;
import progress.message.broker.mqtt.proto.PublishMessage;
import progress.message.util.server.IByteBuffer;

class PublishDecoder
extends DemuxDecoder<PublishMessage> {
    PublishDecoder() {
    }

    @Override
    PublishMessage decode(IByteBuffer in) throws EOFException {
        int startPos = in.countRead();
        PublishMessage message = new PublishMessage();
        if (!this.decodeCommonHeader(message, in)) {
            return null;
        }
        int remainingLength = message.getRemainingLength();
        String topic = MqttCodecUtils.decodeString(in);
        if (topic == null) {
            return null;
        }
        message.setTopic(new MqttTopic(topic));
        if (message.getQos() == MqttQoS.AT_LEAST_ONCE || message.getQos() == MqttQoS.EXACTLY_ONCE) {
            message.setMessageId(in.readUnsignedShort());
        }
        int stopPos = in.countRead();
        int payloadSize = remainingLength - (stopPos - startPos - 2) + (MqttCodecUtils.numBytesToEncode(remainingLength) - 1);
        if (in.countUnread() < payloadSize) {
            return message;
        }
        byte[] messagePayload = new byte[payloadSize];
        in.read(messagePayload);
        message.setPayload(messagePayload);
        return message;
    }
}

