/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import progress.message.broker.mqtt.codec.DemuxDecoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.MqttSubscription;
import progress.message.broker.mqtt.proto.SubscribeMessage;
import progress.message.util.server.IByteBuffer;

class SubscribeDecoder
extends DemuxDecoder<SubscribeMessage> {
    SubscribeDecoder() {
    }

    @Override
    SubscribeMessage decode(IByteBuffer in) throws EOFException {
        SubscribeMessage message = new SubscribeMessage();
        if (!this.decodeCommonHeader(message, 2, in)) {
            return null;
        }
        if (message.getQos() != MqttQoS.AT_LEAST_ONCE) {
            throw new MqttException("Subscribe MUST have QoS 1 (AT_LEAST_ONCE), got QoS = " + (Object)((Object)message.getQos()));
        }
        int start = in.countRead();
        message.setMessageId(in.readUnsignedShort());
        int readed = in.countRead() - start;
        while (readed < message.getRemainingLength()) {
            this.decodeSubscription(in, message);
            readed = in.countRead() - start;
        }
        if (message.subscriptions().isEmpty()) {
            throw new MqttException("Subscribe MUST have got at least one subscription topic filter/QoS");
        }
        return message;
    }

    private void decodeSubscription(IByteBuffer in, SubscribeMessage message) throws EOFException {
        String topic = MqttCodecUtils.decodeString(in);
        byte qosByte = in.readByte();
        if ((qosByte & 0xFC) > 0) {
            throw new MqttException("Subscribe MUST have QoS byte with reserved buts to 0, found = " + Integer.toHexString(qosByte));
        }
        byte qos = (byte)(qosByte & 3);
        message.addSubscription(new MqttSubscription(MqttQoS.valueOf(qos), topic));
    }
}

