/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import progress.message.broker.mqtt.codec.DemuxDecoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.UnsubscribeMessage;
import progress.message.util.server.IByteBuffer;

class UnsubscribeDecoder
extends DemuxDecoder<UnsubscribeMessage> {
    UnsubscribeDecoder() {
    }

    @Override
    UnsubscribeMessage decode(IByteBuffer in) throws EOFException {
        UnsubscribeMessage message = new UnsubscribeMessage();
        if (!this.decodeCommonHeader(message, in)) {
            return null;
        }
        if (message.getQos() != MqttQoS.AT_LEAST_ONCE) {
            throw new MqttException("Unsubscribe MUST have QoS 1 (AT_LEAST_ONCE), got QoS = " + (Object)((Object)message.getQos()));
        }
        int start = in.countRead();
        message.setMessageId(in.readUnsignedShort());
        int readed = in.countRead() - start;
        while (readed < message.getRemainingLength()) {
            message.addTopicFilter(MqttCodecUtils.decodeString(in));
            readed = in.countRead() - start;
        }
        if (message.topicFilters().isEmpty()) {
            throw new MqttException("Unsubscribe MUST have got at least one topic filter");
        }
        return message;
    }
}

