/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.proto;

import progress.message.broker.mqtt.proto.MqttConnectException;

public enum MqttVersion {
    MQTT_3_1_1("MQTT", 4, "MQTT 3.1.1");

    private final String name;
    private final byte level;
    private final String version;

    private MqttVersion(String name, byte level, String version) {
        this.name = name;
        this.level = level;
        this.version = version;
    }

    public static MqttVersion fromProtocolNameAndLevel(String name, byte level) {
        for (MqttVersion mv : MqttVersion.values()) {
            if (!mv.name.equals(name)) continue;
            if (mv.level == level) {
                return mv;
            }
            throw new MqttConnectException(name + " and " + level + " are not match", 1);
        }
        throw new MqttConnectException(name + "is unknown protocol name", 1);
    }

    public String getName() {
        return this.name;
    }

    public byte getLevel() {
        return this.level;
    }

    public String getVersion() {
        return this.version;
    }
}

