/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.parser;

import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.SelectorTreeConstants;
import progress.message.broker.parser.SimpleNode;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.zclient.xonce.MgramTrace;

public class Identifier
extends SimpleNode {
    static final String JMSDeliveryMode = "JMSDeliveryMode".intern();
    static final String JMSPriority = "JMSPriority".intern();
    static final String JMSMessageID = "JMSMessageID".intern();
    static final String JMSTimestamp = "JMSTimestamp".intern();
    static final String JMSCorrelationID = "JMSCorrelationID".intern();
    static final String JMSType = "JMSType".intern();
    String name = null;

    public Identifier(int id) {
        super(id);
    }

    public Identifier(Selector p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        return SelectorTreeConstants.jjtNodeName[this.id] + " : " + this.name;
    }

    @Override
    public Object eval(IMgram m) throws EvalException {
        if (!m.hasSidebandData()) {
            throw new EAssertFailure(MgramTrace.diagnosticString("Unable to evaluate selector against message without properties: ", null, m));
        }
        String uniqueName = this.name.intern();
        if (uniqueName == JMSDeliveryMode) {
            return new Integer(m.isJMSPersistent() ? 2 : 1);
        }
        if (uniqueName == JMSPriority) {
            return new Integer(m.getPriority());
        }
        if (uniqueName == JMSMessageID) {
            String sep = ":";
            StringBuffer id = new StringBuffer();
            id.append("ID:");
            id.append(Long.toHexString(m.getSidebandData().getBrokerID()));
            id.append(":");
            id.append(Long.toHexString(m.getSidebandData().getConnectionAndLocalID()));
            id.append(":");
            id.append(Long.toHexString(m.getSidebandData().getTimestamp()).toUpperCase());
            return id.toString();
        }
        if (uniqueName == JMSTimestamp) {
            return new Long(m.getSidebandData().getTimestamp());
        }
        if (uniqueName == JMSCorrelationID) {
            return m.getSidebandData().getCorrelationID();
        }
        if (uniqueName == JMSType) {
            return m.getSidebandData().getType();
        }
        return m.getSidebandData().getProperties().get(this.name);
    }
}

